/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.hover.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.hoverable.HoverManager;
import net.infonode.gui.hover.hoverable.Hoverable;
import net.infonode.gui.shaped.panel.ShapedPanel;

public class HoverableShapedPanel
extends ShapedPanel
implements Hoverable {
    private HoverListener hoverListener;
    private Component hoveredComponent;
    private boolean hovered = false;

    public HoverableShapedPanel(HoverListener listener) {
        this(new BorderLayout(), listener, null);
    }

    public HoverableShapedPanel(LayoutManager l, HoverListener listener) {
        this(l, listener, null);
    }

    public HoverableShapedPanel(LayoutManager l, HoverListener listener, Component hoveredComponent) {
        super(l);
        this.hoveredComponent = hoveredComponent != null ? hoveredComponent : this;
        HoverManager.getInstance().addHoverable(this);
        this.setHoverListener(listener);
    }

    public HoverListener getHoverListener() {
        return this.hoverListener;
    }

    public void setHoverListener(HoverListener newHoverListener) {
        if (this.hoverListener != newHoverListener) {
            HoverListener oldHoverListener = this.hoverListener;
            this.hoverListener = newHoverListener;
            if (oldHoverListener != null && newHoverListener != null && this.hovered) {
                HoverEvent event = new HoverEvent(this.hoveredComponent);
                oldHoverListener.mouseExited(event);
                newHoverListener.mouseEntered(event);
            }
        }
    }

    @Override
    public void hoverEnter() {
        if (this.hoverListener != null) {
            this.hovered = true;
            this.hoverListener.mouseEntered(new HoverEvent(this.hoveredComponent));
        }
    }

    @Override
    public void hoverExit() {
        if (this.hoverListener != null) {
            this.hovered = false;
            this.hoverListener.mouseExited(new HoverEvent(this.hoveredComponent));
        }
    }

    public Component getHoveredComponent() {
        return this.hoveredComponent;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public boolean acceptHover(ArrayList enterableHoverables) {
        return true;
    }
}

