/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.cycle;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.cycle.DirectedSimpleCycles;

public class HawickJamesSimpleCycles<V, E>
implements DirectedSimpleCycles<V, E> {
    private DirectedGraph<V, E> graph = null;
    private int nVertices = 0;
    private long nCycles = 0L;
    private List<List<V>> cycles = null;
    private Integer start = 0;
    private List<Integer>[] Ak = null;
    private List<Integer>[] B = null;
    private boolean[] blocked = null;
    private ArrayDeque<Integer> stack = null;
    private V[] iToV = null;
    private Map<V, Integer> vToI = null;

    public HawickJamesSimpleCycles() {
    }

    public HawickJamesSimpleCycles(DirectedGraph<V, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("Null graph argument.");
        }
        this.graph = graph;
    }

    private void initState(Operation o) {
        int i;
        this.nCycles = 0L;
        this.nVertices = this.graph.vertexSet().size();
        if (o == Operation.ENUMERATE) {
            this.cycles = new ArrayList<List<V>>();
        }
        this.blocked = new boolean[this.nVertices];
        this.stack = new ArrayDeque(this.nVertices);
        this.B = new ArrayList[this.nVertices];
        for (i = 0; i < this.nVertices; ++i) {
            this.B[i] = new ArrayList<Integer>();
        }
        this.iToV = this.graph.vertexSet().toArray();
        this.vToI = new HashMap<V, Integer>();
        for (i = 0; i < this.iToV.length; ++i) {
            this.vToI.put((Integer)this.iToV[i], i);
        }
        this.Ak = this.buildAdjacencyList();
        this.stack.clear();
    }

    private List<Integer>[] buildAdjacencyList() {
        ArrayList[] Ak = new ArrayList[this.nVertices];
        for (int j = 0; j < this.nVertices; ++j) {
            V v = this.iToV[j];
            List<V> s = Graphs.successorListOf(this.graph, v);
            Ak[j] = new ArrayList(s.size());
            Iterator<V> iterator = s.iterator();
            while (iterator.hasNext()) {
                Ak[j].add(this.vToI.get(iterator.next()));
            }
        }
        return Ak;
    }

    private void clearState() {
        this.Ak = null;
        this.nVertices = 0;
        this.blocked = null;
        this.stack = null;
        this.iToV = null;
        this.vToI = null;
        for (int i = 0; i < this.nVertices; ++i) {
            this.Ak[i] = null;
            this.B[i] = null;
        }
        this.Ak = null;
        this.B = null;
    }

    private boolean circuit(Integer v, Operation o) {
        boolean f = false;
        this.stack.push(v);
        this.blocked[v.intValue()] = true;
        for (Integer w : this.Ak[v]) {
            if (w < this.start) continue;
            if (w == this.start) {
                if (o == Operation.ENUMERATE) {
                    ArrayList<V> cycle = new ArrayList<V>(this.stack.size());
                    Iterator<Integer> iteratorStack = this.stack.iterator();
                    while (iteratorStack.hasNext()) {
                        cycle.add(this.iToV[iteratorStack.next()]);
                    }
                    this.cycles.add(cycle);
                }
                if (o == Operation.PRINT_ONLY) {
                    for (Integer i : this.stack) {
                        System.out.print(this.iToV[i].toString() + " ");
                    }
                    System.out.println("");
                }
                ++this.nCycles;
                f = true;
                continue;
            }
            if (this.blocked[w] || !this.circuit(w, o)) continue;
            f = true;
        }
        if (f) {
            this.unblock(v);
        } else {
            for (Integer w : this.Ak[v]) {
                if (w < this.start || this.B[w].contains(v)) continue;
                this.B[w].add(v);
            }
        }
        this.stack.pop();
        return f;
    }

    private void unblock(Integer u) {
        this.blocked[u.intValue()] = false;
        for (int wPos = 0; wPos < this.B[u].size(); ++wPos) {
            Integer w = this.B[u].get(wPos);
            wPos -= this.removeFromList(this.B[u], w);
            if (!this.blocked[w]) continue;
            this.unblock(w);
        }
    }

    private int removeFromList(List<Integer> list, Integer u) {
        int nOccurrences = 0;
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer w = iterator.next();
            if (w != u) continue;
            ++nOccurrences;
            iterator.remove();
        }
        return nOccurrences;
    }

    @Override
    public DirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(DirectedGraph<V, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("Null graph argument.");
        }
        this.graph = graph;
    }

    @Override
    public List<List<V>> findSimpleCycles() throws IllegalArgumentException {
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        this.initState(Operation.ENUMERATE);
        for (int i = 0; i < this.nVertices; ++i) {
            for (int j = 0; j < this.nVertices; ++j) {
                this.blocked[j] = false;
                this.B[j].clear();
            }
            this.start = this.vToI.get(this.iToV[i]);
            this.circuit(this.start, Operation.ENUMERATE);
        }
        List<List<V>> result = this.cycles;
        this.clearState();
        return result;
    }

    public void printSimpleCycles() {
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        this.initState(Operation.PRINT_ONLY);
        for (int i = 0; i < this.nVertices; ++i) {
            for (int j = 0; j < this.nVertices; ++j) {
                this.blocked[j] = false;
                this.B[j].clear();
            }
            this.start = this.vToI.get(this.iToV[i]);
            this.circuit(this.start, Operation.PRINT_ONLY);
        }
        this.clearState();
    }

    public long countSimpleCycles() {
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        this.initState(Operation.COUNT_ONLY);
        for (int i = 0; i < this.nVertices; ++i) {
            for (int j = 0; j < this.nVertices; ++j) {
                this.blocked[j] = false;
                this.B[j].clear();
            }
            this.start = this.vToI.get(this.iToV[i]);
            this.circuit(this.start, Operation.COUNT_ONLY);
        }
        this.clearState();
        return this.nCycles;
    }

    private static enum Operation {
        ENUMERATE,
        PRINT_ONLY,
        COUNT_ONLY;

    }
}

