/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panelsearch.items;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import org.zaproxy.zap.view.panelsearch.HighlightedComponent;
import org.zaproxy.zap.view.panelsearch.HighlighterUtils;
import org.zaproxy.zap.view.panelsearch.SearchQuery;
import org.zaproxy.zap.view.panelsearch.items.AbstractComponentSearch;
import org.zaproxy.zap.view.panelsearch.items.TreeNodeElement;

public class TreeNodeElementSearch
extends AbstractComponentSearch<TreeNodeElement> {
    @Override
    protected boolean isSearchMatchingInternal(TreeNodeElement component, SearchQuery query) {
        if (component.getNode() == null) {
            return false;
        }
        return query.match(component.getNode().toString());
    }

    @Override
    protected Object[] getComponentsInternal(TreeNodeElement component) {
        return component.getFakeObjectModelChildren().toArray();
    }

    @Override
    protected HighlightedComponent highlightInternal(TreeNodeElement component) {
        HighlightTreeCellRenderer cellRenderer = this.wrapTreeCellRenderer(component);
        cellRenderer.addHighlightedNode(component.getNode());
        return new HighlightedComponent(component);
    }

    @Override
    protected void undoHighlightInternal(HighlightedComponent highlightedComponent, TreeNodeElement component) {
        this.revertWrappedTreeCellRenderer(component);
    }

    @Override
    protected HighlightedComponent highlightAsParentInternal(TreeNodeElement component) {
        HighlightTreeCellRenderer cellRenderer = this.wrapTreeCellRenderer(component);
        cellRenderer.addHighlightedParentNode(component.getNode());
        return new HighlightedComponent(component);
    }

    @Override
    protected void undoHighlightAsParentInternal(HighlightedComponent highlightedComponent, TreeNodeElement component) {
        this.revertWrappedTreeCellRenderer(component);
    }

    private HighlightTreeCellRenderer wrapTreeCellRenderer(TreeNodeElement component) {
        if (!(component.getTree().getCellRenderer() instanceof HighlightTreeCellRenderer)) {
            TreeCellRenderer currentCellRenderer = component.getTree().getCellRenderer();
            component.getTree().setCellRenderer(new HighlightTreeCellRenderer(currentCellRenderer));
        }
        return (HighlightTreeCellRenderer)component.getTree().getCellRenderer();
    }

    private void revertWrappedTreeCellRenderer(TreeNodeElement component) {
        if (component.getTree().getCellRenderer() instanceof HighlightTreeCellRenderer) {
            HighlightTreeCellRenderer highlightCellRenderer = (HighlightTreeCellRenderer)component.getTree().getCellRenderer();
            component.getTree().setCellRenderer(highlightCellRenderer.getOriginalCellRenderer());
        }
    }

    public static class HighlightTreeCellRenderer
    implements TreeCellRenderer {
        private ArrayList<Object> highlightedNodes = new ArrayList();
        private ArrayList<Object> highlightedParentNodes = new ArrayList();
        private TreeCellRenderer originalCellRenderer;

        public HighlightTreeCellRenderer(TreeCellRenderer originalCellRenderer) {
            this.originalCellRenderer = originalCellRenderer;
        }

        public void addHighlightedNode(Object node) {
            this.highlightedNodes.add(node);
        }

        public void addHighlightedParentNode(Object node) {
            this.highlightedParentNodes.add(node);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component cell = this.originalCellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.resetRenderer(cell);
            if (this.highlightedNodes.contains(value)) {
                this.trySetOpaque(cell, true);
                cell.setBackground(HighlighterUtils.getHighlightColor());
            } else if (this.highlightedParentNodes.contains(value)) {
                this.trySetBorder(cell, HighlighterUtils.getHighlightColor());
            }
            return cell;
        }

        private void resetRenderer(Component cell) {
            this.trySetOpaque(cell, false);
            this.trySetBorder(cell, null);
            cell.setBackground(null);
        }

        private void trySetOpaque(Component cell, boolean isOpaque) {
            if (cell instanceof JComponent) {
                ((JComponent)cell).setOpaque(isOpaque);
            }
        }

        private void trySetBorder(Component cell, Color color) {
            if (cell instanceof JComponent) {
                Border border = null;
                if (color != null) {
                    border = BorderFactory.createLineBorder(color, 2);
                }
                ((JComponent)cell).setBorder(border);
            }
        }

        public TreeCellRenderer getOriginalCellRenderer() {
            if (this.originalCellRenderer instanceof Component) {
                Component originalCellRendererAsComponent = (Component)((Object)this.originalCellRenderer);
                this.resetRenderer(originalCellRendererAsComponent);
            }
            return this.originalCellRenderer;
        }
    }
}

