/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.oo;

import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.PrivilegeMapping;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

@Deprecated
public class OODatabaseMetaData
extends FBDatabaseMetaData {
    private static final DatatypeCoder datatypeCoder = DefaultDatatypeCoder.forEncodingFactory(EncodingFactory.createInstance(StandardCharsets.UTF_8));
    private static final String DEFAULT_SCHEMA = "DEFAULT";
    private static final String GET_TABLE_PRIVILEGES_START_1 = "SELECT null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, RDB$GRANTOR as GRANTOR, RDB$USER as GRANTEE, RDB$PRIVILEGE as PRIVILEGE, RDB$GRANT_OPTION as IS_GRANTABLE FROM RDB$USER_PRIVILEGES WHERE ";
    private static final String GET_TABLE_PRIVILEGES_END_1 = " CURRENT_USER IN (RDB$USER, RDB$GRANTOR) AND RDB$FIELD_NAME IS NULL AND RDB$OBJECT_TYPE = 0";
    private static final String GET_TABLE_PRIVILEGES_START_2 = "UNION SELECT null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, RDB$GRANTOR as GRANTOR, CURRENT_USER as GRANTEE, RDB$PRIVILEGE as PRIVILEGE, RDB$GRANT_OPTION as IS_GRANTABLE FROM RDB$USER_PRIVILEGES WHERE ";
    private static final String GET_TABLE_PRIVILEGES_END_2 = " RDB$USER IN (CURRENT_ROLE, 'PUBLIC') AND RDB$FIELD_NAME IS NULL AND RDB$OBJECT_TYPE = 0 ORDER BY 3, 6";

    public OODatabaseMetaData(FBConnection c) throws SQLException {
        super(c);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        FBResultSet rs;
        if (DEFAULT_SCHEMA.equals(schemaPattern)) {
            schemaPattern = null;
        }
        if ((rs = (FBResultSet)super.getTables(catalog, schemaPattern, tableNamePattern, types)).next()) {
            rs.beforeFirst();
            return rs;
        }
        tableNamePattern = tableNamePattern.toUpperCase(Locale.ROOT);
        return super.getTables(catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        FBResultSet rs;
        if (DEFAULT_SCHEMA.equals(schemaPattern)) {
            schemaPattern = null;
        }
        if ((rs = (FBResultSet)super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern)).next()) {
            rs.beforeFirst();
            return rs;
        }
        String upperTableNamePattern = tableNamePattern.toUpperCase(Locale.ROOT);
        String upperColumnNamePattern = columnNamePattern.toUpperCase(Locale.ROOT);
        rs = (FBResultSet)super.getColumns(catalog, schemaPattern, upperTableNamePattern, columnNamePattern);
        if (rs.next()) {
            rs.beforeFirst();
            return rs;
        }
        rs = (FBResultSet)super.getColumns(catalog, schemaPattern, tableNamePattern, upperColumnNamePattern);
        if (rs.next()) {
            rs.beforeFirst();
            return rs;
        }
        return super.getColumns(catalog, schemaPattern, upperTableNamePattern, upperColumnNamePattern);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = this.buildTablePrivilegeRSMetaData();
        Clause tableClause1 = new Clause("RDB$RELATION_NAME", tableNamePattern);
        Clause tableClause2 = new Clause("RDB$RELATION_NAME", tableNamePattern);
        String sql = GET_TABLE_PRIVILEGES_START_1;
        sql = sql + tableClause1.getCondition();
        sql = sql + GET_TABLE_PRIVILEGES_END_1;
        sql = sql + GET_TABLE_PRIVILEGES_START_2;
        sql = sql + tableClause2.getCondition();
        sql = sql + GET_TABLE_PRIVILEGES_END_2;
        ArrayList<String> params = new ArrayList<String>(2);
        if (tableClause1.hasCondition()) {
            params.add(tableClause1.getValue());
        }
        if (tableClause2.hasCondition()) {
            params.add(tableClause2.getValue());
        }
        try (ResultSet rs = this.doQuery(sql, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            FBResultSet fBResultSet = this.processTablePrivileges(rowDescriptor, rs);
            return fBResultSet;
        }
    }

    private RowDescriptor buildTablePrivilegeRSMetaData() {
        return new RowDescriptorBuilder(7, datatypeCoder).at(0).simple(448, 63, "TABLE_CAT", "TABLEPRIV").addField().at(1).simple(448, 63, "TABLE_SCHEM", "TABLEPRIV").addField().at(2).simple(448, 63, "TABLE_NAME", "TABLEPRIV").addField().at(3).simple(448, 63, "GRANTOR", "TABLEPRIV").addField().at(4).simple(448, 63, "GRANTEE", "TABLEPRIV").addField().at(5).simple(448, 31, "PRIVILEGE", "TABLEPRIV").addField().at(6).simple(448, 31, "IS_GRANTABLE", "TABLEPRIV").addField().toRowDescriptor();
    }

    private FBResultSet processTablePrivileges(RowDescriptor rowDescriptor, ResultSet fbTablePrivileges) throws SQLException {
        ArrayList<RowValue> rows = new ArrayList<RowValue>();
        RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
        do {
            rows.add(valueBuilder.at(2).setString(fbTablePrivileges.getString("TABLE_NAME")).at(3).setString(fbTablePrivileges.getString("GRANTOR")).at(4).setString(fbTablePrivileges.getString("GRANTEE")).at(5).setString(PrivilegeMapping.mapPrivilege(fbTablePrivileges.getString("PRIVILEGE"))).at(6).setString(fbTablePrivileges.getShort("IS_GRANTABLE") == 0 ? "NO" : "YES").toRowValue(true));
        } while (fbTablePrivileges.next());
        return new FBResultSet(rowDescriptor, rows);
    }
}

