/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.lists.hunspell;

import ai.grazie.nlp.utils.CharUtils;
import ai.grazie.nlp.utils.Symbols;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.utils.CollectionsKt;
import ai.grazie.utils.TextKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.lucene.analysis.hunspell.AffixedWord;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.FragmentChecker;
import org.apache.lucene.analysis.hunspell.Hunspell;
import org.apache.lucene.analysis.hunspell.NGramFragmentChecker;
import org.apache.lucene.analysis.hunspell.SortingStrategy;
import org.apache.lucene.analysis.hunspell.Suggester;
import org.apache.lucene.analysis.hunspell.SuggestionTimeoutException;
import org.apache.lucene.analysis.hunspell.TimeoutPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0004,-./B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u000eH\u0014J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J \u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u001fj\b\u0012\u0004\u0012\u00020\u0019` 2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\"2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0017\u0010)\u001a\u0004\u0018\u00010$2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010#\u001a\u00020$X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&\u00a8\u00060"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList;", "Lai/grazie/spell/lists/WordListWithFrequency;", "affix", "Ljava/io/InputStream;", "dict", "checkCanceled", "Ljava/lang/Runnable;", "defaultIterationLimit", "", "<init>", "(Ljava/io/InputStream;Ljava/io/InputStream;Ljava/lang/Runnable;J)V", "dictionary", "Lorg/apache/lucene/analysis/hunspell/Dictionary;", "suggester", "Lorg/apache/lucene/analysis/hunspell/Suggester;", "getSuggester", "()Lorg/apache/lucene/analysis/hunspell/Suggester;", "suggester$delegate", "Lkotlin/Lazy;", "createSuggester", "hunspell", "Lorg/apache/lucene/analysis/hunspell/Hunspell;", "getHunspell", "()Lorg/apache/lucene/analysis/hunspell/Hunspell;", "language", "", "contains", "", "word", "caseSensitive", "suggest", "Ljava/util/LinkedHashSet;", "Lai/grazie/utils/LinkedSet;", "suggestNonEmpty", "Lkotlin/sequences/Sequence;", "maxFrequency", "", "getMaxFrequency", "()I", "defaultFrequency", "getDefaultFrequency", "getFrequency", "(Ljava/lang/String;)Ljava/lang/Integer;", "hasApEnding", "Companion", "EnglishVerbChecker", "GermanNumeralChecker", "GermanVerbChecker", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nHunspellWordList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HunspellWordList.kt\nai/grazie/spell/lists/hunspell/HunspellWordList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public class HunspellWordList
implements WordListWithFrequency {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Runnable checkCanceled;
    private final long defaultIterationLimit;
    @NotNull
    private final Dictionary dictionary;
    @NotNull
    private final Lazy suggester$delegate;
    private final int maxFrequency;
    private final int defaultFrequency;
    private static final long MAX_TIME_LIMIT = 30000L;
    @NotNull
    private static final Regex verbClasses = new Regex(".*[IYZ].*");
    @NotNull
    private static final Regex innerApostropheS = new Regex("(.+)[" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]s");
    @NotNull
    private static final Regex sRegex = new Regex("[" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]s$");
    @NotNull
    private static final Regex inRegex = new Regex("in[" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]$");

    public HunspellWordList(@NotNull InputStream affix, @NotNull InputStream dict, @NotNull Runnable checkCanceled, long defaultIterationLimit) {
        Intrinsics.checkNotNullParameter((Object)affix, (String)"affix");
        Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
        Intrinsics.checkNotNullParameter((Object)checkCanceled, (String)"checkCanceled");
        this.checkCanceled = checkCanceled;
        this.defaultIterationLimit = defaultIterationLimit;
        this.dictionary = new Dictionary(affix, kotlin.collections.CollectionsKt.listOf((Object)dict), false, SortingStrategy.inMemory());
        this.suggester$delegate = LazyKt.lazy(() -> HunspellWordList.suggester_delegate$lambda$1(this));
        this.maxFrequency = 127;
    }

    public /* synthetic */ HunspellWordList(InputStream inputStream, InputStream inputStream2, Runnable runnable, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            runnable = HunspellWordList::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            l = 250000L;
        }
        this(inputStream, inputStream2, runnable, l);
    }

    private final Suggester getSuggester() {
        Lazy lazy = this.suggester$delegate;
        return (Suggester)lazy.getValue();
    }

    @NotNull
    protected Suggester createSuggester() {
        Suggester suggester = new Suggester(this.dictionary).withSuggestibleEntryCache().proceedPastRep();
        Intrinsics.checkNotNullExpressionValue((Object)suggester, (String)"proceedPastRep(...)");
        return suggester;
    }

    private final Hunspell getHunspell() {
        return new Hunspell(this.dictionary, TimeoutPolicy.RETURN_PARTIAL_RESULT, new Runnable(this){
            private long iterations;
            final /* synthetic */ HunspellWordList this$0;
            {
                this.this$0 = $receiver;
                this.iterations = HunspellWordList.access$getDefaultIterationLimit$p($receiver);
            }

            public final long getIterations() {
                return this.iterations;
            }

            public final void setIterations(long l) {
                this.iterations = l;
            }

            public void run() {
                if (this.iterations == 0L) {
                    throw new SuggestionTimeoutException("Out of iterations", kotlin.collections.CollectionsKt.emptyList());
                }
                --this.iterations;
                HunspellWordList.access$getCheckCanceled$p(this.this$0).run();
            }
        });
    }

    @Nullable
    public final String language() {
        Field field = Dictionary.class.getDeclaredField("language");
        if (field.trySetAccessible()) {
            return (String)field.get(this.dictionary);
        }
        return null;
    }

    @Override
    public boolean contains(@NotNull String word, boolean caseSensitive) {
        String clean;
        block9: {
            String toCheck;
            block10: {
                block11: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
                        clean = StringsKt.replace$default((String)word, (String)String.valueOf(CharUtils.INSTANCE.getSOFT_HYPHEN()), (String)"", (boolean)false, (int)4, null);
                        if (!caseSensitive) break block8;
                        if (this.getHunspell().spell(clean)) {
                            return true;
                        }
                        break block9;
                    }
                    String string = StringsKt.replace$default((String)clean, (String)"\u00df", (String)"+", (boolean)false, (int)4, null).toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    toCheck = StringsKt.replace$default((String)string, (String)"+", (String)"\u00df", (boolean)false, (int)4, null);
                    if (!Intrinsics.areEqual((Object)this.language(), (Object)"de") || !StringsKt.contains$default((CharSequence)clean, (CharSequence)"ss", (boolean)false, (int)2, null)) break block10;
                    if (!this.getHunspell().spell(toCheck)) break block9;
                    Hunspell hunspell2 = this.getHunspell();
                    String string2 = clean.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    if (hunspell2.spell(TextKt.capitalize(string2))) break block11;
                    Hunspell hunspell3 = this.getHunspell();
                    String string3 = clean.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!hunspell3.spell(string3)) break block9;
                }
                return true;
                break block9;
            }
            if (this.getHunspell().spell(toCheck)) {
                return true;
            }
        }
        if (Intrinsics.areEqual((Object)this.language(), (Object)"de") && caseSensitive) {
            CharSequence charSequence = clean;
            Regex regex = innerApostropheS;
            String string = "$1";
            clean = regex.replace(charSequence, string);
            if (this.getHunspell().analyzeSimpleWord(clean + "e").stream().anyMatch(arg_0 -> HunspellWordList.contains$lambda$3(HunspellWordList::contains$lambda$2, arg_0))) {
                return true;
            }
        }
        if (Intrinsics.areEqual((Object)this.language(), (Object)"de") && (new GermanNumeralChecker().isComplexNumeral(word) || new GermanVerbChecker(this.getHunspell()).isVerb(word))) {
            return true;
        }
        return Intrinsics.areEqual((Object)this.language(), (Object)"en") && (this.hasApEnding(word, this.getHunspell()) || new EnglishVerbChecker(this.getHunspell()).isOldVerb(word));
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String clean = StringsKt.replace$default((String)word, (String)String.valueOf(CharUtils.INSTANCE.getSOFT_HYPHEN()), (String)"", (boolean)false, (int)4, null);
        LinkedHashSet<String> overall = CollectionsKt.toLinkedSet(this.suggestNonEmpty(clean));
        if (TextKt.isLowercase(clean) && clean.length() > 3) {
            kotlin.collections.CollectionsKt.addAll((Collection)overall, (Sequence)SequencesKt.filter(this.suggestNonEmpty(TextKt.capitalize(clean)), arg_0 -> HunspellWordList.suggest$lambda$4(overall, arg_0)));
        }
        return overall;
    }

    private final Sequence<String> suggestNonEmpty(String word) {
        List list;
        try {
            list = this.getSuggester().suggestWithTimeout(word, 30000L, this.checkCanceled);
        }
        catch (SuggestionTimeoutException e) {
            list = e.getPartialResult();
        }
        List list2 = list;
        Intrinsics.checkNotNull((Object)list2);
        return SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)list2), HunspellWordList::suggestNonEmpty$lambda$5);
    }

    @Override
    public int getMaxFrequency() {
        return this.maxFrequency;
    }

    @Override
    public int getDefaultFrequency() {
        return this.defaultFrequency;
    }

    @Override
    @Nullable
    public Integer getFrequency(@NotNull String word) {
        Integer result2;
        Comparable comparable;
        List list;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        List it = list = this.getHunspell().getRoots(word);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        List list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            return null;
        }
        List roots = list2;
        Iterator iterator = ((Iterable)roots).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            String it2 = (String)iterator.next();
            boolean bl2 = false;
            List list3 = this.dictionary.lookupEntries(it2).getMorphologicalValues(0, "fr:");
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getMorphologicalValues(...)");
            String string = (String)kotlin.collections.CollectionsKt.getOrNull((List)list3, (int)0);
            Comparable comparable2 = Integer.valueOf(string != null ? Integer.parseInt(string) : this.getDefaultFrequency());
            while (iterator.hasNext()) {
                String it3 = (String)iterator.next();
                $i$a$-maxOfOrNull-HunspellWordList$getFrequency$result$1 = false;
                List list4 = this.dictionary.lookupEntries(it3).getMorphologicalValues(0, "fr:");
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getMorphologicalValues(...)");
                String string2 = (String)kotlin.collections.CollectionsKt.getOrNull((List)list4, (int)0);
                Comparable comparable3 = Integer.valueOf(string2 != null ? Integer.parseInt(string2) : this.getDefaultFrequency());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = result2 = (Integer)comparable;
        return n != null ? n.intValue() : this.getDefaultFrequency();
    }

    private final boolean hasApEnding(String word, Hunspell hunspell2) {
        CharSequence charSequence = word;
        Regex regex = sRegex;
        String string = "";
        regex = inRegex;
        String apWord = regex.replace(charSequence = (CharSequence)regex.replace(charSequence, string), string = "ing");
        return !Intrinsics.areEqual((Object)apWord, (Object)word) && hunspell2.spell(apWord);
    }

    private static final void _init_$lambda$0() {
    }

    private static final Suggester suggester_delegate$lambda$1(HunspellWordList this$0) {
        return this$0.createSuggester();
    }

    private static final boolean contains$lambda$2(AffixedWord aw) {
        String string = aw.getDictEntry().getFlags();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFlags(...)");
        CharSequence charSequence = string;
        return verbClasses.matches(charSequence);
    }

    private static final boolean contains$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean suggest$lambda$4(LinkedHashSet $overall, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return !$overall.contains(string) && !$overall.contains(it) && !StringsKt.contains$default((CharSequence)it, (CharSequence)" ", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (CharSequence)"-", (boolean)false, (int)2, null);
    }

    private static final boolean suggestNonEmpty$lambda$5(String it) {
        Intrinsics.checkNotNull((Object)it);
        return ((CharSequence)it).length() > 0;
    }

    public static final /* synthetic */ long access$getDefaultIterationLimit$p(HunspellWordList $this) {
        return $this.defaultIterationLimit;
    }

    public static final /* synthetic */ Runnable access$getCheckCanceled$p(HunspellWordList $this) {
        return $this.checkCanceled;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\fJ \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList$Companion;", "", "<init>", "()V", "MAX_TIME_LIMIT", "", "create", "Lai/grazie/spell/lists/hunspell/HunspellWordList;", "affDict", "", "dicDict", "trigrams", "", "checkCanceled", "Ljava/lang/Runnable;", "verbClasses", "Lkotlin/text/Regex;", "innerApostropheS", "sRegex", "inRegex", "gec-spell-engine-local"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HunspellWordList create(@NotNull String affDict, @NotNull String dicDict, @Nullable List<String> trigrams) {
            Intrinsics.checkNotNullParameter((Object)affDict, (String)"affDict");
            Intrinsics.checkNotNullParameter((Object)dicDict, (String)"dicDict");
            return this.create(affDict, dicDict, trigrams, Companion::create$lambda$0);
        }

        @Deprecated(message="Specify trigrams if possible", replaceWith=@ReplaceWith(expression="create(affDict, dicDict, null, checkCanceled)", imports={}))
        @NotNull
        public final HunspellWordList create(@NotNull String affDict, @NotNull String dicDict, @NotNull Runnable checkCanceled) {
            Intrinsics.checkNotNullParameter((Object)affDict, (String)"affDict");
            Intrinsics.checkNotNullParameter((Object)dicDict, (String)"dicDict");
            Intrinsics.checkNotNullParameter((Object)checkCanceled, (String)"checkCanceled");
            return this.create(affDict, dicDict, null, checkCanceled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final HunspellWordList create(@NotNull String affDict, @NotNull String dicDict, @Nullable List<String> trigrams, @NotNull Runnable checkCanceled) {
            HunspellWordList hunspellWordList;
            Intrinsics.checkNotNullParameter((Object)affDict, (String)"affDict");
            Intrinsics.checkNotNullParameter((Object)dicDict, (String)"dicDict");
            Intrinsics.checkNotNullParameter((Object)checkCanceled, (String)"checkCanceled");
            Object object = affDict;
            Object object2 = Charsets.UTF_8;
            byte[] byArray = ((String)object).getBytes((Charset)object2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            object = new ByteArrayInputStream(byArray);
            object2 = null;
            try {
                HunspellWordList hunspellWordList2;
                ByteArrayInputStream affix = (ByteArrayInputStream)object;
                boolean bl = false;
                Object object3 = dicDict;
                Object object4 = Charsets.UTF_8;
                byte[] byArray2 = ((String)object3).getBytes((Charset)object4);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                object3 = new ByteArrayInputStream(byArray2);
                object4 = null;
                try {
                    ByteArrayInputStream dictionary = (ByteArrayInputStream)object3;
                    boolean bl2 = false;
                    hunspellWordList2 = new HunspellWordList(affix, dictionary, checkCanceled, trigrams){
                        final /* synthetic */ List<String> $trigrams;
                        {
                            this.$trigrams = $trigrams;
                            super($affix, $dictionary, $checkCanceled, 0L, 8, null);
                        }

                        protected Suggester createSuggester() {
                            Suggester suggester;
                            Suggester caching = super.createSuggester();
                            if (this.$trigrams == null) {
                                suggester = caching;
                            } else {
                                Suggester suggester2 = caching.withFragmentChecker((FragmentChecker)NGramFragmentChecker.fromWords((int)3, (Collection)this.$trigrams));
                                suggester = suggester2;
                                Intrinsics.checkNotNullExpressionValue((Object)suggester2, (String)"withFragmentChecker(...)");
                            }
                            return suggester;
                        }
                    };
                }
                catch (Throwable throwable) {
                    object4 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
                }
                hunspellWordList = hunspellWordList2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            return hunspellWordList;
        }

        public static /* synthetic */ HunspellWordList create$default(Companion companion, String string, String string2, List list, Runnable runnable, int n, Object object) {
            if ((n & 4) != 0) {
                list = null;
            }
            return companion.create(string, string2, list, runnable);
        }

        private static final void create$lambda$0() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList$EnglishVerbChecker;", "", "hunspell", "Lorg/apache/lucene/analysis/hunspell/Hunspell;", "<init>", "(Lorg/apache/lucene/analysis/hunspell/Hunspell;)V", "getHunspell", "()Lorg/apache/lucene/analysis/hunspell/Hunspell;", "isOldVerb", "", "word", "", "Companion", "gec-spell-engine-local"})
    private static final class EnglishVerbChecker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Hunspell hunspell;
        @NotNull
        private static final Regex oldVerb = new Regex("(.{2,})e(d?st|th)");

        public EnglishVerbChecker(@NotNull Hunspell hunspell2) {
            Intrinsics.checkNotNullParameter((Object)hunspell2, (String)"hunspell");
            this.hunspell = hunspell2;
        }

        @NotNull
        public final Hunspell getHunspell() {
            return this.hunspell;
        }

        public final boolean isOldVerb(@NotNull String word) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            MatchResult matchResult = oldVerb.matchEntire((CharSequence)word);
            if (matchResult == null) {
                return false;
            }
            MatchResult match = matchResult;
            String stem = (String)match.getGroupValues().get(1);
            return this.hunspell.spell(stem + "ing");
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList$EnglishVerbChecker$Companion;", "", "<init>", "()V", "oldVerb", "Lkotlin/text/Regex;", "gec-spell-engine-local"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList$GermanNumeralChecker;", "", "<init>", "()V", "isComplexNumeral", "", "word", "", "Companion", "gec-spell-engine-local"})
    private static final class GermanNumeralChecker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String NUM45689 = "drei|vier|f\u00fcnf|sechs|acht|neun";
        @NotNull
        private static final String TO9 = "((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))";
        @NotNull
        private static final String TO99 = "(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)";
        @NotNull
        private static final String TO999 = "((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)";
        @NotNull
        private static final Regex numeralRegex = new Regex("((((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)tausend)?((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?|((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)?(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))?hundert)tausend|((((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)hundert)(((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))|((und)?(ein|zwei|sieben|drei|vier|f\u00fcnf|sechs|acht|neun))(und((zwan|sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zig|drei\u00dfig))?|zehn|elf|zw\u00f6lf|(sieb|drei|vier|f\u00fcnf|sechs|acht|neun)zehn)?)");

        public final boolean isComplexNumeral(@NotNull String word) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            CharSequence charSequence = word;
            return numeralRegex.matches(charSequence);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList$GermanNumeralChecker$Companion;", "", "<init>", "()V", "NUM45689", "", "TO9", "TO99", "TO999", "numeralRegex", "Lkotlin/text/Regex;", "gec-spell-engine-local"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList$GermanVerbChecker;", "", "hunspell", "Lorg/apache/lucene/analysis/hunspell/Hunspell;", "<init>", "(Lorg/apache/lucene/analysis/hunspell/Hunspell;)V", "getHunspell", "()Lorg/apache/lucene/analysis/hunspell/Hunspell;", "isInDictionary", "", "word", "", "looksLikeNoun", "looksLikeVerb", "isVerb", "Companion", "gec-spell-engine-local"})
    private static final class GermanVerbChecker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Hunspell hunspell;
        @NotNull
        private static final Regex presPartRegex = new Regex(".+nde[mnsr]");
        @NotNull
        private static final String PREFIX = "(ab|aus(einander)?|vorbei|zur\u00fcck|umher|hoch|durch|empor|entlang|entgegen|da?(rauf|r\u00fcber)|da(bei|von)|(he)?r(ab|an|aus|auf|ein|um|unter|\u00fcber)|her(ab|bei|vor)?|hin(ab|aus|durch|ein|ter(her)?)?)";
        @NotNull
        private static final Regex verbRegex = new Regex("(ab|aus(einander)?|vorbei|zur\u00fcck|umher|hoch|durch|empor|entlang|entgegen|da?(rauf|r\u00fcber)|da(bei|von)|(he)?r(ab|an|aus|auf|ein|um|unter|\u00fcber)|her(ab|bei|vor)?|hin(ab|aus|durch|ein|ter(her)?)?)(zu)?(.+)");

        public GermanVerbChecker(@NotNull Hunspell hunspell2) {
            Intrinsics.checkNotNullParameter((Object)hunspell2, (String)"hunspell");
            this.hunspell = hunspell2;
        }

        @NotNull
        public final Hunspell getHunspell() {
            return this.hunspell;
        }

        private final boolean isInDictionary(String word) {
            return this.hunspell.spell(word);
        }

        private final boolean looksLikeNoun(String word) {
            return this.isInDictionary(TextKt.capitalize(word) + "s") || this.isInDictionary(TextKt.capitalize(word) + "es");
        }

        private final boolean looksLikeVerb(String word) {
            CharSequence charSequence;
            return (StringsKt.endsWith$default((String)word, (String)"t", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)word, (String)"en", (boolean)false, (int)2, null)) && StringsKt.startsWith$default((String)word, (String)"ge", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)word, (String)"nd", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)1)) || StringsKt.endsWith$default((String)word, (String)"nde", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)2)) || presPartRegex.matches(charSequence = (CharSequence)word) && this.isInDictionary(StringsKt.dropLast((String)word, (int)3)) || StringsKt.endsWith$default((String)word, (String)"en", (boolean)false, (int)2, null) && (this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "st") || this.isInDictionary(StringsKt.dropLast((String)word, (int)2) + "st")) || StringsKt.endsWith$default((String)word, (String)"n", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "st") || StringsKt.endsWith$default((String)word, (String)"te", (boolean)false, (int)2, null) && this.isInDictionary(word + "st") || StringsKt.endsWith$default((String)word, (String)"t", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "st") && (this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "en") || this.isInDictionary(StringsKt.dropLast((String)word, (int)1) + "n")) || StringsKt.endsWith$default((String)word, (String)"st", (boolean)false, (int)2, null) && this.isInDictionary(StringsKt.dropLast((String)word, (int)2) + "t") || !this.looksLikeNoun(word) && this.isInDictionary(word + "en") && this.isInDictionary(word + "et");
        }

        public final boolean isVerb(@NotNull String word) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            if (!TextKt.isLowercase(word) || !verbRegex.matches(charSequence = (CharSequence)word)) {
                return false;
            }
            Object object = verbRegex;
            CharSequence charSequence2 = word;
            String string = "$11";
            String cleanVerb = object.replace(charSequence2, string);
            if (Intrinsics.areEqual((Object)cleanVerb, (Object)"sein")) {
                return true;
            }
            object = word;
            string = verbRegex;
            String string2 = "$10";
            boolean zu = Intrinsics.areEqual((Object)string.replace((CharSequence)object, string2), (Object)"zu");
            return this.isInDictionary(cleanVerb) && this.looksLikeVerb(cleanVerb) && (!zu || this.isInDictionary(cleanVerb + "d"));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList$GermanVerbChecker$Companion;", "", "<init>", "()V", "presPartRegex", "Lkotlin/text/Regex;", "PREFIX", "", "verbRegex", "gec-spell-engine-local"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

