/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RecentTaskRepositories", storages={@Storage(value="other.xml")})
@Service(value={Service.Level.APP})
public final class RecentTaskRepositories
implements PersistentStateComponent<Element>,
Disposable {
    private final Set<TaskRepository> myRepositories;
    private static final HashingStrategy<TaskRepository> HASHING_STRATEGY = new HashingStrategy<TaskRepository>(){

        public int hashCode(@Nullable TaskRepository object) {
            return object == null || object.getUrl() == null ? 0 : object.getUrl().hashCode();
        }

        public boolean equals(TaskRepository o1, TaskRepository o2) {
            return o1 == o2 || o1 != null && o2 != null && Objects.equals(o1.getUrl(), o2.getUrl());
        }
    };

    public RecentTaskRepositories(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            RecentTaskRepositories.$$$reportNull$$$0(0);
        }
        this.myRepositories = CollectionFactory.createCustomHashingStrategySet(HASHING_STRATEGY);
        TaskRepositoryType.addEPListChangeListener((CoroutineScope)coroutineScope, () -> {
            List possibleRepositoryClasses = TaskRepositoryType.getRepositoryClasses();
            this.myRepositories.removeIf(repository -> !ContainerUtil.exists((Iterable)possibleRepositoryClasses, clazz -> clazz.isAssignableFrom(repository.getClass())));
        });
    }

    public static RecentTaskRepositories getInstance() {
        return (RecentTaskRepositories)ApplicationManager.getApplication().getService(RecentTaskRepositories.class);
    }

    public Set<TaskRepository> getRepositories() {
        Set set = CollectionFactory.createCustomHashingStrategySet(HASHING_STRATEGY);
        set.addAll(ContainerUtil.findAll(this.myRepositories, repository -> !StringUtil.isEmptyOrSpaces((String)repository.getUrl())));
        return set;
    }

    public void addRepositories(Collection<TaskRepository> repositories) {
        ArrayList<TaskRepository> old = new ArrayList<TaskRepository>(this.myRepositories);
        this.myRepositories.clear();
        if (this.doAddReps(repositories)) {
            return;
        }
        this.doAddReps(old);
    }

    private boolean doAddReps(Collection<TaskRepository> repositories) {
        for (TaskRepository repository : repositories) {
            if (StringUtil.isEmptyOrSpaces((String)repository.getUrl())) continue;
            if (this.myRepositories.size() == 10) {
                return true;
            }
            this.myRepositories.add(repository);
        }
        return false;
    }

    public Element getState() {
        return XmlSerializer.serialize((Object)this.myRepositories.toArray(new TaskRepository[0]));
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            RecentTaskRepositories.$$$reportNull$$$0(1);
        }
        this.myRepositories.clear();
        this.myRepositories.addAll(TaskManagerImpl.loadRepositories((Element)state));
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tasks/config/RecentTaskRepositories";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

