/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.Bytes;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.TimeUnit;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.IndicesResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class IndicesRequest
extends CatRequestBase
implements ToCopyableBuilder<Builder, IndicesRequest> {
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final HealthStatus health;
    @Nullable
    private final Boolean includeUnloadedSegments;
    @Nonnull
    private final List<String> index;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Boolean pri;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<IndicesRequest, IndicesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<IndicesRequest, IndicesResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_cat/indices";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat/indices/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, IndicesResponse._DESERIALIZER);

    private IndicesRequest(Builder builder) {
        super(builder);
        this.bytes = builder.bytes;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.health = builder.health;
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.masterTimeout = builder.masterTimeout;
        this.pri = builder.pri;
        this.time = builder.time;
    }

    public static IndicesRequest of(Function<Builder, ObjectBuilder<IndicesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final HealthStatus health() {
        return this.health;
    }

    @Nullable
    public final Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Boolean pri() {
        return this.pri;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.bytes != null) {
            params.put("bytes", this.bytes.jsonValue());
        }
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.health != null) {
            params.put("health", this.health.jsonValue());
        }
        if (this.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(this.includeUnloadedSegments));
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (this.pri != null) {
            params.put("pri", String.valueOf(this.pri));
        }
        if (this.time != null) {
            params.put("time", this.time.jsonValue());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.bytes);
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.health);
        result = 31 * result + Objects.hashCode(this.includeUnloadedSegments);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.pri);
        result = 31 * result + Objects.hashCode(this.time);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndicesRequest other = (IndicesRequest)o;
        return Objects.equals(this.bytes, other.bytes) && Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.health, other.health) && Objects.equals(this.includeUnloadedSegments, other.includeUnloadedSegments) && Objects.equals(this.index, other.index) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.pri, other.pri) && Objects.equals(this.time, other.time);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, IndicesRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private HealthStatus health;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private List<String> index;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Boolean pri;
        @Nullable
        private TimeUnit time;

        public Builder() {
        }

        private Builder(IndicesRequest o) {
            super(o);
            this.bytes = o.bytes;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.health = o.health;
            this.includeUnloadedSegments = o.includeUnloadedSegments;
            this.index = Builder._listCopy(o.index);
            this.masterTimeout = o.masterTimeout;
            this.pri = o.pri;
            this.time = o.time;
        }

        private Builder(Builder o) {
            super(o);
            this.bytes = o.bytes;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.health = o.health;
            this.includeUnloadedSegments = o.includeUnloadedSegments;
            this.index = Builder._listCopy(o.index);
            this.masterTimeout = o.masterTimeout;
            this.pri = o.pri;
            this.time = o.time;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder health(@Nullable HealthStatus value) {
            this.health = value;
            return this;
        }

        @Nonnull
        public final Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder pri(@Nullable Boolean value) {
            this.pri = value;
            return this;
        }

        @Nonnull
        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        @Nonnull
        public IndicesRequest build() {
            this._checkSingleUse();
            return new IndicesRequest(this);
        }
    }
}

