/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.builder.Json;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class NativeImageProxyConfigStep {
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void generateProxyConfig(BuildProducer<GeneratedResourceBuildItem> proxyConfig, List<NativeImageProxyDefinitionBuildItem> proxies) {
        Json.JsonArrayBuilder root = Json.array();
        for (NativeImageProxyDefinitionBuildItem proxy : proxies) {
            Json.JsonArrayBuilder interfaces = Json.array();
            for (String cl : proxy.getClasses()) {
                interfaces.add(cl);
            }
            Json.JsonObjectBuilder proxyJson = Json.object();
            proxyJson.put("interfaces", interfaces);
            root.add(proxyJson);
        }
        try (StringWriter writer = new StringWriter();){
            root.appendTo((Appendable)writer);
            proxyConfig.produce(new GeneratedResourceBuildItem("META-INF/native-image/proxy-config.json", writer.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

