/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.instantiation.internal;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import org.hibernate.internal.util.beans.BeanInfoHelper;
import org.hibernate.query.sqm.tree.expression.Compatibility;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class InstantiationHelper {
    private static final Logger log = Logger.getLogger(InstantiationHelper.class);

    private InstantiationHelper() {
    }

    public static boolean isInjectionCompatible(Class<?> targetJavaType, List<String> aliases, List<Class<?>> argTypes) {
        return BeanInfoHelper.visitBeanInfo(targetJavaType, beanInfo -> {
            for (int i = 0; i < aliases.size(); ++i) {
                Class argType;
                String alias = (String)aliases.get(i);
                if (InstantiationHelper.checkArgument(targetJavaType, beanInfo, alias, argType = (Class)argTypes.get(i))) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean checkArgument(Class<?> targetJavaType, BeanInfo beanInfo, String alias, Class<?> argType) {
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!InstantiationHelper.propertyMatches(alias, argType, propertyDescriptor)) continue;
            return true;
        }
        return InstantiationHelper.findField(targetJavaType, alias, argType) != null;
    }

    public static boolean isConstructorCompatible(Class<?> javaClass, List<Class<?>> argTypes, TypeConfiguration typeConfiguration) {
        return InstantiationHelper.findMatchingConstructor(javaClass, argTypes, typeConfiguration) != null;
    }

    public static <T> Constructor<T> findMatchingConstructor(Class<T> type, List<Class<?>> argumentTypes, TypeConfiguration typeConfiguration) {
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            if (!InstantiationHelper.isConstructorCompatible(constructor, argumentTypes, typeConfiguration)) continue;
            return constructor;
        }
        return null;
    }

    public static boolean isConstructorCompatible(Constructor<?> constructor, List<Class<?>> argumentTypes, TypeConfiguration typeConfiguration) {
        Type[] genericParameterTypes = constructor.getGenericParameterTypes();
        if (genericParameterTypes.length == argumentTypes.size()) {
            for (int i = 0; i < argumentTypes.size(); ++i) {
                Class classParameter;
                Class type;
                Type parameterType = genericParameterTypes[i];
                Class<?> argumentType = argumentTypes.get(i);
                Class clazz = type = parameterType instanceof Class ? (classParameter = (Class)parameterType) : typeConfiguration.getJavaTypeRegistry().resolveDescriptor(parameterType).getJavaTypeClass();
                if (Compatibility.areAssignmentCompatible(type, argumentType)) continue;
                if (log.isDebugEnabled()) {
                    log.debugf("Skipping constructor for dynamic-instantiation match due to argument mismatch [%s] : %s -> %s", i, (Object)argumentType.getTypeName(), (Object)parameterType.getTypeName());
                }
                return false;
            }
            return true;
        }
        return false;
    }

    static Field findField(Class<?> declaringClass, String name, Class<?> javaType) {
        block3: {
            try {
                Field field = declaringClass.getDeclaredField(name);
                if (Compatibility.areAssignmentCompatible(field.getType(), javaType)) {
                    field.setAccessible(true);
                    return field;
                }
            }
            catch (NoSuchFieldException ignore) {
                if (declaringClass.getSuperclass() == null) break block3;
                return InstantiationHelper.findField(declaringClass.getSuperclass(), name, javaType);
            }
        }
        return null;
    }

    static boolean propertyMatches(String alias, Class<?> argType, PropertyDescriptor propertyDescriptor) {
        return alias.equals(propertyDescriptor.getName()) && propertyDescriptor.getWriteMethod() != null && Compatibility.areAssignmentCompatible(propertyDescriptor.getWriteMethod().getParameterTypes()[0], argType);
    }
}

