/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

@Internal
public class Insert {
    protected String tableName;
    protected String comment;
    protected Map<String, String> columns = new LinkedHashMap<String, String>();
    private final Dialect dialect;
    private final ParameterMarkerStrategy parameterMarkerStrategy;
    private int parameterCount;

    public Insert(SessionFactoryImplementor sessionFactory) {
        this(sessionFactory.getJdbcServices().getJdbcEnvironment().getDialect(), sessionFactory.getParameterMarkerStrategy());
    }

    public Insert(Dialect dialect, ParameterMarkerStrategy parameterMarkerStrategy) {
        this.dialect = dialect;
        this.parameterMarkerStrategy = parameterMarkerStrategy;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    public Insert setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Map<String, String> getColumns() {
        return this.columns;
    }

    public Insert addColumn(String columnName) {
        return this.addColumn(columnName, "?");
    }

    public Insert addColumns(String[] columnNames) {
        for (String columnName : columnNames) {
            this.addColumn(columnName);
        }
        return this;
    }

    public Insert addColumns(String[] columnNames, boolean[] insertable) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!insertable[i]) continue;
            this.addColumn(columnNames[i]);
        }
        return this;
    }

    public Insert addColumns(String[] columnNames, boolean[] insertable, String[] valueExpressions) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!insertable[i]) continue;
            this.addColumn(columnNames[i], valueExpressions[i]);
        }
        return this;
    }

    public Insert addColumn(String columnName, String valueExpression) {
        this.columns.put(columnName, valueExpression);
        return this;
    }

    public Insert addIdentityColumn(String columnName) {
        IdentityColumnSupport identityColumnSupport = this.dialect.getIdentityColumnSupport();
        if (identityColumnSupport.hasIdentityInsertKeyword()) {
            this.addColumn(columnName, identityColumnSupport.getIdentityInsertString());
        }
        return this;
    }

    public Insert addGeneratedColumns(String[] columnNames, OnExecutionGenerator generator) {
        if (generator.referenceColumnsInSql(this.dialect)) {
            String[] columnValues = generator.getReferencedColumnValues(this.dialect);
            if (columnNames.length != columnValues.length) {
                throw new MappingException("wrong number of generated columns");
            }
            for (int i = 0; i < columnNames.length; ++i) {
                this.addColumn(columnNames[i], columnValues[i]);
            }
        }
        return this;
    }

    public Insert setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toStatementString() {
        StringBuilder buf = new StringBuilder(this.columns.size() * 15 + this.tableName.length() + 10);
        if (this.comment != null) {
            buf.append("/* ").append(Dialect.escapeComment(this.comment)).append(" */ ");
        }
        buf.append("insert into ").append(this.tableName);
        if (this.columns.isEmpty()) {
            if (!this.dialect.supportsNoColumnsInsert()) throw new MappingException(String.format("The INSERT statement for table [%s] contains no column, and this is not supported by [%s]", this.tableName, this.dialect));
            buf.append(' ').append(this.dialect.getNoColumnsInsertString());
            return buf.toString();
        } else {
            buf.append(" (");
            this.renderInsertionSpec(buf);
            buf.append(") values (");
            this.renderRowValues(buf);
            buf.append(')');
        }
        return buf.toString();
    }

    private void renderInsertionSpec(StringBuilder buf) {
        Iterator<String> itr = this.columns.keySet().iterator();
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(", ");
        }
    }

    private void renderRowValues(StringBuilder buf) {
        Iterator<String> itr = this.columns.values().iterator();
        while (itr.hasNext()) {
            buf.append(this.normalizeExpressionFragment(itr.next()));
            if (!itr.hasNext()) continue;
            buf.append(", ");
        }
    }

    private String normalizeExpressionFragment(String rhs) {
        return rhs.equals("?") ? this.parameterMarkerStrategy.createMarker(++this.parameterCount, null) : rhs;
    }
}

