/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.CharBuffer;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.IntStack;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.Topology;

final class Parser {
    private final IntStack stack = new IntStack(10);
    private final Graph g;
    private RingBond[] rings = new RingBond[10];
    private Map<Integer, LocalArrangement> arrangement = new HashMap<Integer, LocalArrangement>(5);
    private Map<Integer, Configuration> configurations = new HashMap<Integer, Configuration>(5);
    private Bond bond = Bond.IMPLICIT;
    private Configuration configuration = Configuration.UNKNOWN;
    private Set<Integer> start = new TreeSet<Integer>();
    private int openRings = 0;
    private final boolean strict;
    private BitSet checkDirectionalBonds = new BitSet();
    private int lastBondPos = -1;
    private Map<Edge, Integer> bondStrPos = new HashMap<Edge, Integer>();
    private List<String> warnings = new ArrayList<String>();
    private boolean hasAstrix = false;

    Parser(CharBuffer buffer, boolean strict) throws InvalidSmilesException {
        this.strict = strict;
        this.g = new Graph(1 + 2 * (buffer.length() / 3));
        this.readSmiles(buffer);
        if (this.openRings > 0) {
            throw new InvalidSmilesException("Unclosed ring detected, SMILES may be truncated:", buffer);
        }
        if (this.stack.size() > 1) {
            throw new InvalidSmilesException("Unclosed branch detected, SMILES may be truncated:", buffer);
        }
        this.start.add(0);
        if (this.g.getFlags(14) != 0) {
            this.createTopologies(buffer);
        }
        if (this.hasAstrix) {
            for (int i = 0; i < this.g.order(); ++i) {
                Atom atom = this.g.atom(i);
                if (atom.element() != Element.Unknown) continue;
                int nArom = 0;
                for (Edge e : this.g.edges(i)) {
                    if (e.bond() != Bond.AROMATIC && (e.bond() != Bond.IMPLICIT || !this.g.atom(e.other(i)).aromatic())) continue;
                    ++nArom;
                }
                if (nArom < 2) continue;
                if (atom == AtomImpl.AliphaticSubset.Any) {
                    this.g.setAtom(i, AtomImpl.AromaticSubset.Any);
                    continue;
                }
                this.g.setAtom(i, new AtomImpl.BracketAtom(-1, Element.Unknown, atom.label(), atom.hydrogens(), atom.charge(), atom.atomClass(), true));
            }
        }
    }

    Parser(String str) throws InvalidSmilesException {
        this(CharBuffer.fromString(str), false);
    }

    static Graph strict(String str) throws InvalidSmilesException {
        return new Parser(CharBuffer.fromString(str), true).molecule();
    }

    static Graph losse(String str) throws InvalidSmilesException {
        return new Parser(CharBuffer.fromString(str), false).molecule();
    }

    Graph molecule() {
        return this.g;
    }

    private void createTopologies(CharBuffer buffer) throws InvalidSmilesException {
        for (Map.Entry<Integer, Configuration> e : this.configurations.entrySet()) {
            this.addTopology(e.getKey(), Topology.toExplicit(this.g, e.getKey(), e.getValue()));
        }
        int v = this.checkDirectionalBonds.nextSetBit(0);
        while (v >= 0) {
            Bond bond;
            Object e;
            int j;
            int nUpV = 0;
            int nDownV = 0;
            int nUpW = 0;
            int nDownW = 0;
            int w = -1;
            int d = this.g.degree(v);
            for (j = 0; j < d; ++j) {
                e = this.g.edgeAt(v, j);
                bond = ((Edge)e).bond(v);
                if (bond == Bond.UP) {
                    ++nUpV;
                    continue;
                }
                if (bond == Bond.DOWN) {
                    ++nDownV;
                    continue;
                }
                if (bond != Bond.DOUBLE) continue;
                w = ((Edge)e).other(v);
            }
            if (w >= 0) {
                this.checkDirectionalBonds.clear(w);
                d = this.g.degree(w);
                for (j = 0; j < d; ++j) {
                    e = this.g.edgeAt(w, j);
                    bond = ((Edge)e).bond(w);
                    if (bond == Bond.UP) {
                        ++nUpW;
                        continue;
                    }
                    if (bond != Bond.DOWN) continue;
                    ++nDownW;
                }
                if (nUpV + nDownV != 0 && nUpW + nDownW != 0) {
                    Object errorPos;
                    int offset2;
                    int offset1;
                    if (nUpV > 1 || nDownV > 1) {
                        offset1 = -1;
                        offset2 = -1;
                        for (Edge e2 : this.g.edges(v)) {
                            if (!e2.bond().directional()) continue;
                            if (offset1 < 0) {
                                offset1 = this.bondStrPos.get(e2);
                                continue;
                            }
                            offset2 = this.bondStrPos.get(e2);
                        }
                        errorPos = InvalidSmilesException.display(buffer, offset1 - buffer.length(), offset2 - buffer.length());
                        if (this.strict) {
                            throw new InvalidSmilesException("Ignored invalid Cis/Trans specification: " + (String)errorPos);
                        }
                        this.warnings.add("Ignored invalid Cis/Trans specification: " + (String)errorPos);
                    }
                    if (nUpW > 1 || nDownW > 1) {
                        offset1 = -1;
                        offset2 = -1;
                        for (Edge e2 : this.g.edges(w)) {
                            if (!e2.bond().directional()) continue;
                            if (offset1 < 0) {
                                offset1 = this.bondStrPos.get(e2);
                                continue;
                            }
                            offset2 = this.bondStrPos.get(e2);
                        }
                        errorPos = InvalidSmilesException.display(buffer, offset1 - buffer.length(), offset2 - buffer.length());
                        if (this.strict) {
                            throw new InvalidSmilesException("Ignored invalid Cis/Trans specification: " + (String)errorPos);
                        }
                        this.warnings.add("Ignored invalid Cis/Trans specification: " + (String)errorPos);
                    }
                }
            }
            v = this.checkDirectionalBonds.nextSetBit(v + 1);
        }
    }

    public List<Edge> getEdges(LocalArrangement localArrangement, int u) {
        if (localArrangement == null) {
            return this.g.edges(u);
        }
        int[] vs = localArrangement.toArray();
        ArrayList<Edge> edges = new ArrayList<Edge>(vs.length);
        for (int v : vs) {
            edges.add(this.g.edge(u, v));
        }
        return edges;
    }

    private int getOtherDb(int u, int v) {
        for (Edge e : this.getLocalEdges(u)) {
            int nbr;
            if (e.bond() != Bond.DOUBLE || (nbr = e.other(u)) == v) continue;
            return nbr;
        }
        return -1;
    }

    private int[] findExtendedTetrahedralEnds(int focus) {
        List<Edge> es = this.getLocalEdges(focus);
        int prevEnd1 = focus;
        int prevEnd2 = focus;
        int end1 = es.get(0).other(prevEnd2);
        int end2 = es.get(1).other(prevEnd2);
        while (end1 >= 0 && end2 >= 0) {
            int tmp = this.getOtherDb(end1, prevEnd1);
            prevEnd1 = end1;
            end1 = tmp;
            tmp = this.getOtherDb(end2, prevEnd2);
            prevEnd2 = end2;
            end2 = tmp;
        }
        return new int[]{prevEnd1, prevEnd2};
    }

    private List<Edge> getLocalEdges(int end) {
        return this.getEdges(this.arrangement.get(end), end);
    }

    public int[] getAlleneCarriers(int focus) {
        int[] carriers = new int[4];
        int i = 0;
        int[] ends = this.findExtendedTetrahedralEnds(focus);
        int beg = ends[0];
        int end = ends[1];
        boolean begh = this.g.implHCount(beg) == 1;
        boolean endh = this.g.implHCount(end) == 1;
        ArrayList<Edge> begEdges = new ArrayList<Edge>(this.getLocalEdges(beg));
        if (begh) {
            begEdges.add(this.start.contains(beg) ? 0 : 1, null);
        }
        for (Edge bEdge : this.getLocalEdges(beg)) {
            if (bEdge == null) {
                carriers[i++] = beg;
                continue;
            }
            int bnbr = bEdge.other(beg);
            if (beg < bnbr && begh) {
                carriers[i++] = beg;
                begh = false;
            }
            if (bEdge.bond() == Bond.DOUBLE) {
                ArrayList<Edge> endEdges = new ArrayList<Edge>(this.getLocalEdges(end));
                if (endh) {
                    endEdges.add(1, null);
                }
                for (Edge eEdge : endEdges) {
                    if (eEdge == null) {
                        carriers[i++] = end;
                        continue;
                    }
                    if (eEdge.bond() == Bond.DOUBLE) continue;
                    carriers[i++] = eEdge.other(end);
                }
                continue;
            }
            carriers[i++] = bnbr;
        }
        if (i != 4) {
            return null;
        }
        return carriers;
    }

    private void addTopology(int u, Configuration c) throws InvalidSmilesException {
        if (this.arrangement.containsKey(u)) {
            int[] us = this.arrangement.get(u).toArray();
            List<Edge> es = this.getLocalEdges(u);
            if (c.type() == Configuration.Type.Tetrahedral) {
                us = this.insertThImplicitRef(u, us);
            } else if (c.type() == Configuration.Type.DoubleBond) {
                us = this.insertDbImplicitRef(u, us);
            } else if (c.type() == Configuration.Type.ExtendedTetrahedral) {
                this.g.addFlags(4);
                us = this.getAlleneCarriers(u);
                if (us == null) {
                    if (this.strict) {
                        throw new InvalidSmilesException("Invalid Allene stereo");
                    }
                    this.warnings.add("Ignored invalid Allene stereochemistry");
                    return;
                }
            } else {
                if (c.type() == Configuration.Type.SquarePlanar && us.length != 4) {
                    if (this.strict) {
                        throw new InvalidSmilesException("SquarePlanar without 4 explicit neighbours");
                    }
                    this.warnings.add("SquarePlanar without 4 explicit neighbours");
                    return;
                }
                if (c.type() == Configuration.Type.TrigonalBipyramidal && us.length != 5) {
                    if (this.strict) {
                        throw new InvalidSmilesException("SquarePlanar without 5 explicit neighbours");
                    }
                    this.warnings.add("SquarePlanar without 5 explicit neighbours");
                    return;
                }
                if (c.type() == Configuration.Type.Octahedral && us.length != 6) {
                    if (this.strict) {
                        throw new InvalidSmilesException("SquarePlanar without 6 explicit neighbours");
                    }
                    this.warnings.add("SquarePlanar without 6 explicit neighbours");
                    return;
                }
            }
            this.g.addTopology(Topology.create(u, us, es, c));
        } else {
            int[] us = new int[this.g.degree(u)];
            List<Edge> es = this.g.edges(u);
            for (int i = 0; i < us.length; ++i) {
                us[i] = es.get(i).other(u);
            }
            if (c.type() == Configuration.Type.Tetrahedral) {
                us = this.insertThImplicitRef(u, us);
            } else if (c.type() == Configuration.Type.DoubleBond) {
                us = this.insertDbImplicitRef(u, us);
            } else if (c.type() == Configuration.Type.ExtendedTetrahedral) {
                this.g.addFlags(4);
                us = this.getAlleneCarriers(u);
                if (us == null) {
                    return;
                }
            }
            this.g.addTopology(Topology.create(u, us, es, c));
        }
    }

    private int[] insertThImplicitRef(int u, int[] vs) throws InvalidSmilesException {
        if (vs.length == 4) {
            return vs;
        }
        if (vs.length != 3) {
            throw new InvalidSmilesException("Invaid number of verticies for TH1/TH2 stereo chemistry");
        }
        if (this.start.contains(u)) {
            return new int[]{u, vs[0], vs[1], vs[2]};
        }
        return new int[]{vs[0], u, vs[1], vs[2]};
    }

    private int[] insertDbImplicitRef(int u, int[] vs) throws InvalidSmilesException {
        if (vs.length == 3) {
            return vs;
        }
        if (vs.length != 2) {
            throw new InvalidSmilesException("Invaid number of verticies for DB1/DB2 stereo chemistry");
        }
        if (this.start.contains(u)) {
            return new int[]{u, vs[0], vs[1]};
        }
        return new int[]{vs[0], u, vs[1]};
    }

    private void addAtom(Atom a, CharBuffer buffer) throws InvalidSmilesException {
        int v = this.g.addAtom(a);
        if (!this.stack.empty()) {
            int u = this.stack.pop();
            if (this.bond != Bond.DOT) {
                Edge e = new Edge(u, v, this.bond);
                if (this.bond.directional()) {
                    this.bondStrPos.put(e, this.lastBondPos);
                    this.checkDirectionalBonds.set(u);
                    this.checkDirectionalBonds.set(v);
                }
                this.g.addEdge(e);
                if (this.arrangement.containsKey(u)) {
                    this.arrangement.get(u).add(v);
                }
            } else {
                this.start.add(v);
            }
        }
        this.stack.push(v);
        this.bond = Bond.IMPLICIT;
        if (this.configuration != Configuration.UNKNOWN) {
            this.g.addFlags(2);
            this.configurations.put(v, this.configuration);
            this.configuration = Configuration.UNKNOWN;
        }
    }

    private void readSmiles(CharBuffer buffer) throws InvalidSmilesException {
        block35: while (buffer.hasRemaining()) {
            char c = buffer.get();
            switch (c) {
                case '*': {
                    this.hasAstrix = true;
                    this.addAtom(AtomImpl.AliphaticSubset.Any, buffer);
                    continue block35;
                }
                case 'B': {
                    if (buffer.getIf('r')) {
                        this.addAtom(AtomImpl.AliphaticSubset.Bromine, buffer);
                        continue block35;
                    }
                    this.addAtom(AtomImpl.AliphaticSubset.Boron, buffer);
                    continue block35;
                }
                case 'C': {
                    if (buffer.getIf('l')) {
                        this.addAtom(AtomImpl.AliphaticSubset.Chlorine, buffer);
                        continue block35;
                    }
                    this.addAtom(AtomImpl.AliphaticSubset.Carbon, buffer);
                    continue block35;
                }
                case 'N': {
                    this.addAtom(AtomImpl.AliphaticSubset.Nitrogen, buffer);
                    continue block35;
                }
                case 'O': {
                    this.addAtom(AtomImpl.AliphaticSubset.Oxygen, buffer);
                    continue block35;
                }
                case 'P': {
                    this.addAtom(AtomImpl.AliphaticSubset.Phosphorus, buffer);
                    continue block35;
                }
                case 'S': {
                    this.addAtom(AtomImpl.AliphaticSubset.Sulfur, buffer);
                    continue block35;
                }
                case 'F': {
                    this.addAtom(AtomImpl.AliphaticSubset.Fluorine, buffer);
                    continue block35;
                }
                case 'I': {
                    this.addAtom(AtomImpl.AliphaticSubset.Iodine, buffer);
                    continue block35;
                }
                case 'b': {
                    this.addAtom(AtomImpl.AromaticSubset.Boron, buffer);
                    this.g.addFlags(1);
                    continue block35;
                }
                case 'c': {
                    this.addAtom(AtomImpl.AromaticSubset.Carbon, buffer);
                    this.g.addFlags(1);
                    continue block35;
                }
                case 'n': {
                    this.addAtom(AtomImpl.AromaticSubset.Nitrogen, buffer);
                    this.g.addFlags(1);
                    continue block35;
                }
                case 'o': {
                    this.addAtom(AtomImpl.AromaticSubset.Oxygen, buffer);
                    this.g.addFlags(1);
                    continue block35;
                }
                case 'p': {
                    this.addAtom(AtomImpl.AromaticSubset.Phosphorus, buffer);
                    this.g.addFlags(1);
                    continue block35;
                }
                case 's': {
                    this.addAtom(AtomImpl.AromaticSubset.Sulfur, buffer);
                    this.g.addFlags(1);
                    continue block35;
                }
                case 'H': {
                    if (this.strict) {
                        throw new InvalidSmilesException("hydrogens should be specified in square brackets - '[H]'", buffer);
                    }
                    this.addAtom(AtomImpl.EXPLICIT_HYDROGEN, buffer);
                    continue block35;
                }
                case 'D': {
                    if (this.strict) {
                        throw new InvalidSmilesException("deuterium should be specified as a hydrogen isotope - '[2H]'", buffer);
                    }
                    this.addAtom(AtomImpl.DEUTERIUM, buffer);
                    continue block35;
                }
                case 'T': {
                    if (this.strict) {
                        throw new InvalidSmilesException("tritium should be specified as a hydrogen isotope - '[3H]'", buffer);
                    }
                    this.addAtom(AtomImpl.TRITIUM, buffer);
                    continue block35;
                }
                case '[': {
                    this.addAtom(this.readBracketAtom(buffer), buffer);
                    continue block35;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.ring(c - 48, buffer);
                    continue block35;
                }
                case '%': {
                    int num = buffer.getNumber(2);
                    if (num < 0) {
                        throw new InvalidSmilesException("a number (<digit>+) must follow '%':", buffer);
                    }
                    if (this.strict && num < 10) {
                        throw new InvalidSmilesException("two digits must follow '%'", buffer);
                    }
                    this.ring(num, buffer);
                    this.lastBondPos = buffer.position();
                    continue block35;
                }
                case '-': {
                    if (this.bond != Bond.IMPLICIT) {
                        throw new InvalidSmilesException("Multiple bonds specified:", buffer);
                    }
                    this.bond = Bond.SINGLE;
                    this.lastBondPos = buffer.position();
                    continue block35;
                }
                case '=': {
                    if (this.bond != Bond.IMPLICIT) {
                        throw new InvalidSmilesException("Multiple bonds specified:", buffer);
                    }
                    this.bond = Bond.DOUBLE;
                    this.lastBondPos = buffer.position();
                    continue block35;
                }
                case '#': {
                    if (this.bond != Bond.IMPLICIT) {
                        throw new InvalidSmilesException("Multiple bonds specified:", buffer);
                    }
                    this.bond = Bond.TRIPLE;
                    this.lastBondPos = buffer.position();
                    continue block35;
                }
                case '$': {
                    if (this.bond != Bond.IMPLICIT) {
                        throw new InvalidSmilesException("Multiple bonds specified:", buffer);
                    }
                    this.bond = Bond.QUADRUPLE;
                    this.lastBondPos = buffer.position();
                    continue block35;
                }
                case ':': {
                    if (this.bond != Bond.IMPLICIT) {
                        throw new InvalidSmilesException("Multiple bonds specified:", buffer);
                    }
                    this.g.addFlags(1);
                    this.bond = Bond.AROMATIC;
                    this.lastBondPos = buffer.position();
                    continue block35;
                }
                case '/': {
                    if (this.bond != Bond.IMPLICIT) {
                        throw new InvalidSmilesException("Multiple bonds specified:", buffer);
                    }
                    this.bond = Bond.UP;
                    this.lastBondPos = buffer.position();
                    this.g.addFlags(8);
                    continue block35;
                }
                case '\\': {
                    if (this.bond != Bond.IMPLICIT && this.bond != Bond.DOWN) {
                        throw new InvalidSmilesException("Multiple bonds specified:", buffer);
                    }
                    this.bond = Bond.DOWN;
                    this.lastBondPos = buffer.position();
                    this.g.addFlags(8);
                    continue block35;
                }
                case '.': {
                    if (this.bond != Bond.IMPLICIT) {
                        throw new InvalidSmilesException("Bond specified before disconnection:", buffer);
                    }
                    this.bond = Bond.DOT;
                    continue block35;
                }
                case '(': {
                    if (this.stack.empty()) {
                        throw new InvalidSmilesException("Cannot open branch at this position, SMILES may be truncated:", buffer);
                    }
                    this.stack.push(this.stack.peek());
                    continue block35;
                }
                case ')': {
                    if (this.stack.size() < 2) {
                        throw new InvalidSmilesException("Closing of an unopened branch, SMILES may be truncated:", buffer);
                    }
                    this.stack.pop();
                    continue block35;
                }
                case '\t': 
                case ' ': {
                    StringBuilder sb = new StringBuilder();
                    while (buffer.hasRemaining() && (c = buffer.get()) != '\n' && c != '\r') {
                        sb.append(c);
                    }
                    this.g.setTitle(sb.toString());
                }
                case '\n': 
                case '\r': {
                    return;
                }
            }
            throw new InvalidSmilesException("unexpected character:", buffer);
        }
    }

    Atom readBracketAtom(CharBuffer buffer) throws InvalidSmilesException {
        int start = buffer.position;
        boolean arbitraryLabel = false;
        if (!buffer.hasRemaining()) {
            throw new InvalidSmilesException("Unclosed bracket atom, SMILES may be truncated", buffer);
        }
        int isotope = buffer.getNumber();
        boolean aromatic = buffer.next() >= 'a' && buffer.next() <= 'z';
        Element element = Element.read(buffer);
        if (element == Element.Unknown) {
            this.hasAstrix = true;
        }
        if (this.strict && element == null) {
            throw new InvalidSmilesException("unrecognised element symbol, SMILES may be truncated: ", buffer);
        }
        if (element != null && aromatic) {
            this.g.addFlags(1);
        }
        if (this.strict && aromatic && !element.aromatic(Element.AromaticSpecification.OpenSmiles)) {
            throw new InvalidSmilesException("abnormal aromatic element", buffer);
        }
        if (element == null) {
            arbitraryLabel = true;
        }
        this.configuration = Configuration.read(buffer);
        int hCount = Parser.readHydrogens(buffer);
        int charge = Parser.readCharge(buffer);
        int atomClass = Parser.readClass(buffer);
        if (!arbitraryLabel && !buffer.getIf(']')) {
            if (this.strict) {
                throw InvalidSmilesException.invalidBracketAtom(buffer);
            }
            arbitraryLabel = true;
        }
        if (arbitraryLabel) {
            int end = buffer.position;
            int depth = 1;
            while (buffer.hasRemaining()) {
                char c = buffer.get();
                if (c == '[') {
                    ++depth;
                } else if (c == ']' && --depth == 0) break;
                ++end;
            }
            if (depth != 0) {
                throw new InvalidSmilesException("unparsable label in bracket atom", buffer, buffer.position - 1);
            }
            String label = buffer.substr(start, end);
            this.hasAstrix = true;
            return new AtomImpl.BracketAtom(label);
        }
        return new AtomImpl.BracketAtom(isotope, element, hCount, charge, atomClass, aromatic);
    }

    static int readHydrogens(CharBuffer buffer) {
        if (buffer.getIf('H')) {
            int count = buffer.getNumber();
            return count < 0 ? 1 : count;
        }
        return 0;
    }

    static int readCharge(CharBuffer buffer) {
        return Parser.readCharge(0, buffer);
    }

    private static int readCharge(int acc, CharBuffer buffer) {
        if (buffer.getIf('+')) {
            return buffer.nextIsDigit() ? acc + buffer.getNumber() : Parser.readCharge(acc + 1, buffer);
        }
        if (buffer.getIf('-')) {
            return buffer.nextIsDigit() ? acc - buffer.getNumber() : Parser.readCharge(acc - 1, buffer);
        }
        return acc;
    }

    static int readClass(CharBuffer buffer) throws InvalidSmilesException {
        if (buffer.getIf(':')) {
            if (buffer.nextIsDigit()) {
                return buffer.getNumber();
            }
            throw new InvalidSmilesException("invalid atom class, <digit>+ must follow ':'", buffer);
        }
        return 0;
    }

    private void ring(int rnum, CharBuffer buffer) throws InvalidSmilesException {
        if (this.bond == Bond.DOT) {
            throw new InvalidSmilesException("a ring bond can not be a 'dot':", buffer, buffer.position());
        }
        if (this.stack.empty()) {
            throw new InvalidSmilesException("No previous atom for ring open!", buffer, buffer.position());
        }
        if (this.rings.length <= rnum || this.rings[rnum] == null) {
            this.openRing(rnum, buffer);
        } else {
            this.closeRing(rnum, buffer);
        }
    }

    private void openRing(int rnum, CharBuffer buf) {
        if (rnum >= this.rings.length) {
            this.rings = Arrays.copyOf(this.rings, Math.min(100, rnum * 2));
        }
        int u = this.stack.peek();
        this.rings[rnum] = new RingBond(u, this.bond, this.lastBondPos);
        this.createArrangement(u).add(-rnum);
        ++this.openRings;
        this.bond = Bond.IMPLICIT;
    }

    private LocalArrangement createArrangement(int u) {
        LocalArrangement la = this.arrangement.get(u);
        if (la == null) {
            la = new LocalArrangement();
            int d = this.g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e = this.g.edgeAt(u, j);
                la.add(e.other(u));
            }
            this.arrangement.put(u, la);
        }
        return la;
    }

    private void closeRing(int rnum, CharBuffer buffer) throws InvalidSmilesException {
        RingBond rbond = this.rings[rnum];
        this.rings[rnum] = null;
        int u = rbond.u;
        int v = this.stack.peek();
        if (u == v) {
            throw new InvalidSmilesException("Endpoints of ringbond are the same - loops are not allowed", buffer);
        }
        if (this.g.adjacent(u, v)) {
            throw new InvalidSmilesException("Endpoints of ringbond are already connected - multi-edges are not allowed", buffer);
        }
        this.bond = this.decideBond(rbond.bond, this.bond.inverse(), rbond.pos, buffer);
        Edge e = new Edge(u, v, this.bond);
        if (this.bond.directional()) {
            this.checkDirectionalBonds.set(u);
            this.checkDirectionalBonds.set(v);
            if (rbond.bond.directional()) {
                this.bondStrPos.put(e, rbond.pos);
            } else {
                this.bondStrPos.put(e, this.lastBondPos);
            }
        }
        this.g.addEdge(e);
        this.bond = Bond.IMPLICIT;
        this.arrangement.get(rbond.u).replace(-rnum, this.stack.peek());
        if (this.arrangement.containsKey(v)) {
            this.arrangement.get(v).add(rbond.u);
        }
        --this.openRings;
    }

    Bond decideBond(Bond a, Bond b, int pos, CharBuffer buffer) throws InvalidSmilesException {
        if (a == b) {
            return a;
        }
        if (a == Bond.IMPLICIT) {
            return b;
        }
        if (b == Bond.IMPLICIT) {
            return a;
        }
        if (this.strict || a.inverse() != b) {
            throw new InvalidSmilesException("Ring closure bonds did not match,  '" + (Object)((Object)a) + "'!='" + (Object)((Object)b) + "':" + InvalidSmilesException.display(buffer, pos - buffer.position, this.lastBondPos - buffer.position));
        }
        this.warnings.add("Ignored invalid Cis/Trans on ring closure, should flip:" + InvalidSmilesException.display(buffer, pos - buffer.position, this.lastBondPos - buffer.position));
        return Bond.IMPLICIT;
    }

    static Graph parse(String str) throws InvalidSmilesException {
        return new Parser(str).molecule();
    }

    public Collection<? extends String> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }

    private static final class LocalArrangement {
        int[] vs = new int[4];
        int n;

        private LocalArrangement() {
        }

        void add(int v) {
            if (this.n == this.vs.length) {
                this.vs = Arrays.copyOf(this.vs, this.n * 2);
            }
            this.vs[this.n++] = v;
        }

        void replace(int u, int v) {
            for (int i = 0; i < this.n; ++i) {
                if (this.vs[i] != u) continue;
                this.vs[i] = v;
                return;
            }
        }

        int[] toArray() {
            return Arrays.copyOf(this.vs, this.n);
        }
    }

    private static final class RingBond {
        int u;
        Bond bond;
        int pos;

        private RingBond(int u, Bond bond, int pos) {
            this.u = u;
            this.bond = bond;
            this.pos = pos;
        }
    }
}

