/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.immutable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.jspecify.annotations.Nullable;

public class ImmutableAttributesSchema {
    public static final ImmutableAttributesSchema EMPTY = new ImmutableAttributesSchema(ImmutableMap.of(), ImmutableList.of());
    final ImmutableMap<Attribute<?>, ImmutableAttributeMatchingStrategy<?>> strategies;
    final ImmutableList<Attribute<?>> precedence;
    private final ImmutableMap<String, Attribute<?>> attributesByName;
    private final int hashCode;

    ImmutableAttributesSchema(ImmutableMap<Attribute<?>, ImmutableAttributeMatchingStrategy<?>> strategies, ImmutableList<Attribute<?>> precedence) {
        this.strategies = strategies;
        this.precedence = precedence;
        this.attributesByName = ImmutableAttributesSchema.computeAttributesByName(strategies);
        this.hashCode = ImmutableAttributesSchema.computeHashCode(strategies, precedence);
    }

    private static ImmutableMap<String, Attribute<?>> computeAttributesByName(ImmutableMap<Attribute<?>, ?> strategies) {
        ImmutableMap.Builder attributesByName = ImmutableMap.builder();
        for (Attribute attribute : strategies.keySet()) {
            attributesByName.put((Object)attribute.getName(), (Object)attribute);
        }
        return attributesByName.buildKeepingLast();
    }

    private static int computeHashCode(ImmutableMap<Attribute<?>, ImmutableAttributeMatchingStrategy<?>> strategies, ImmutableList<Attribute<?>> precedence) {
        int result = strategies.hashCode();
        result = 31 * result + precedence.hashCode();
        return result;
    }

    public ImmutableSet<Attribute<?>> getAttributes() {
        return this.strategies.keySet();
    }

    public <T> ImmutableList<Action<? super MultipleCandidatesDetails<T>>> disambiguationRules(Attribute<T> attribute) {
        ImmutableAttributeMatchingStrategy<T> matchingStrategy = this.getStrategy(attribute);
        if (matchingStrategy != null) {
            return matchingStrategy.getDisambiguationRules();
        }
        return ImmutableList.of();
    }

    public <T> ImmutableList<Action<? super CompatibilityCheckDetails<T>>> compatibilityRules(Attribute<T> attribute) {
        ImmutableAttributeMatchingStrategy<T> matchingStrategy = this.getStrategy(attribute);
        if (matchingStrategy != null) {
            return matchingStrategy.getCompatibilityRules();
        }
        return ImmutableList.of();
    }

    public @Nullable Attribute<?> getAttributeByName(String name) {
        return (Attribute)this.attributesByName.get((Object)name);
    }

    public ImmutableList<Attribute<?>> getAttributeDisambiguationPrecedence() {
        return this.precedence;
    }

    public <T> @Nullable ImmutableAttributeMatchingStrategy<T> getStrategy(Attribute<T> attribute) {
        return (ImmutableAttributeMatchingStrategy)this.strategies.get(attribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAttributesSchema that = (ImmutableAttributesSchema)o;
        return this.strategies.equals(that.strategies) && this.precedence.equals(that.precedence);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static class ImmutableAttributeMatchingStrategy<T> {
        final ImmutableList<Action<? super CompatibilityCheckDetails<T>>> compatibilityRules;
        final ImmutableList<Action<? super MultipleCandidatesDetails<T>>> disambiguationRules;

        public ImmutableAttributeMatchingStrategy(ImmutableList<Action<? super CompatibilityCheckDetails<T>>> compatibilityRules, ImmutableList<Action<? super MultipleCandidatesDetails<T>>> disambiguationRules) {
            this.compatibilityRules = compatibilityRules;
            this.disambiguationRules = disambiguationRules;
        }

        public ImmutableList<Action<? super CompatibilityCheckDetails<T>>> getCompatibilityRules() {
            return this.compatibilityRules;
        }

        public ImmutableList<Action<? super MultipleCandidatesDetails<T>>> getDisambiguationRules() {
            return this.disambiguationRules;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableAttributeMatchingStrategy that = (ImmutableAttributeMatchingStrategy)o;
            return this.compatibilityRules.equals(that.compatibilityRules) && this.disambiguationRules.equals(that.disambiguationRules);
        }

        public int hashCode() {
            return Objects.hash(this.compatibilityRules, this.disambiguationRules);
        }
    }
}

