/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.fed;

import java.sql.ResultSet;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2GlobalObject;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2RemoteServerOptionCache;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2RemoteServerOption;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2Wrapper;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DB2RemoteServer
extends DB2GlobalObject
implements DBPRefreshableObject {
    private final DB2RemoteServerOptionCache optionsCache = new DB2RemoteServerOptionCache();
    private String name;
    private DB2Wrapper db2Wrapper;
    private String type;
    private String version;
    private String remarks;

    public DB2RemoteServer(DB2DataSource db2DataSource, ResultSet dbResult) throws DBException {
        super(db2DataSource, true);
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SERVERNAME");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SERVERTYPE");
        this.version = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SERVERVERSION");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        String db2WrapperName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"WRAPNAME");
        if (db2WrapperName != null) {
            this.db2Wrapper = this.getDataSource().getWrapper((DBRProgressMonitor)new VoidProgressMonitor(), db2WrapperName);
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.optionsCache.clearCache();
        return this;
    }

    @Association
    public Collection<DB2RemoteServerOption> getOptions(DBRProgressMonitor monitor) throws DBException {
        return this.optionsCache.getAllObjects(monitor, this);
    }

    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, editable=false, order=2)
    public DB2Wrapper getDb2Wrapper() {
        return this.db2Wrapper;
    }

    @Property(viewable=true, editable=false, order=3)
    public String getType() {
        return this.type;
    }

    @Property(viewable=true, editable=false, order=4)
    public String getVersion() {
        return this.version;
    }

    @Property(viewable=true, editable=false, length=PropertyLength.MULTILINE, order=5)
    public String getRemarks() {
        return this.remarks;
    }
}

