/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.tools.registry.ToolDescriptor;
import org.jkiss.dbeaver.tools.registry.ToolGroupDescriptor;

public class ToolsRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.tools";
    static final String TAG_TOOLS = "tools";
    static final String TAG_TOOL = "tool";
    static final String TAG_TOOL_GROUP = "toolGroup";
    private static ToolsRegistry instance = null;
    private final Map<String, ToolGroupDescriptor> toolGroups = new LinkedHashMap<String, ToolGroupDescriptor>();
    private final List<ToolDescriptor> tools = new ArrayList<ToolDescriptor>();

    public static synchronized ToolsRegistry getInstance() {
        if (instance == null) {
            instance = new ToolsRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ToolsRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement toolElement;
            IConfigurationElement toolsElement = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = toolsElement.getChildren(TAG_TOOL_GROUP);
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                toolElement = iConfigurationElementArray2[n4];
                ToolGroupDescriptor group = new ToolGroupDescriptor(toolElement);
                this.toolGroups.put(group.getId(), group);
                ++n4;
            }
            iConfigurationElementArray2 = toolsElement.getChildren(TAG_TOOL);
            n3 = iConfigurationElementArray2.length;
            n4 = 0;
            while (n4 < n3) {
                toolElement = iConfigurationElementArray2[n4];
                this.tools.add(new ToolDescriptor(toolElement));
                ++n4;
            }
            ++n2;
        }
    }

    public void dispose() {
        this.tools.clear();
        this.toolGroups.clear();
    }

    ToolGroupDescriptor getToolGroup(String id) {
        return this.toolGroups.get(id);
    }

    public List<ToolDescriptor> getTools() {
        return this.tools;
    }
}

