/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.awt.AWT;
import org.assertj.swing.dependency.jsr305.Nonnull;

final class JListCellCenterQuery {
    @Nonnull
    @RunsInCurrentThread
    static Point cellCenter(@Nonnull JList<?> list, @Nonnull Rectangle cellBounds) {
        Point cellCenter = AWT.centerOf(cellBounds);
        Rectangle visibleRect = list.getVisibleRect();
        if (visibleRect.contains(cellCenter)) {
            return cellCenter;
        }
        Rectangle intersection = visibleRect.intersection(cellBounds);
        return AWT.centerOf(intersection);
    }

    private JListCellCenterQuery() {
    }
}

