/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkConnectedThresholdImageFilter_h
#define sitkConnectedThresholdImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class ConnectedThresholdImageFilter
\brief Label pixels that are connected to a seed and lie within a range of values.

ConnectedThresholdImageFilter labels pixels with ReplaceValue that are connected to an initial Seed AND lie within a Lower and Upper threshold range.
\sa itk::simple::ConnectedThreshold for the procedural interface
\sa itk::ConnectedThresholdImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ConnectedThresholdImageFilter : public ImageFilter {
    public:
      using Self = ConnectedThresholdImageFilter;

      /** Destructor */
      virtual ~ConnectedThresholdImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ConnectedThresholdImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * \brief Set list of image indexes for seeds.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSeedList ( std::vector< std::vector<unsigned int> > SeedList ) { this->m_SeedList = std::move(SeedList); return *this; }

      /**
       * \brief Get list of seeds
       */
      std::vector< std::vector< unsigned int > > GetSeedList() const { return this->m_SeedList; }
      /** \brief Add SeedList point */
      SITK_RETURN_SELF_TYPE_HEADER AddSeed( std::vector< unsigned int > point ) { this->m_SeedList.push_back(std::move(point)); return *this;}
      /** \brief Remove all SeedList points */
      SITK_RETURN_SELF_TYPE_HEADER ClearSeeds( ) { this->m_SeedList.clear(); return *this;}
\

      /**
       * Set Upper and Lower Threshold inputs as values
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLower ( double Lower ) { this->m_Lower = Lower; return *this; }

      /**
       * Get Upper and Lower Threshold inputs as values.
       */
      double GetLower() const { return this->m_Lower; }\

      /**
       * Set Upper and Lower Threshold inputs as values
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUpper ( double Upper ) { this->m_Upper = Upper; return *this; }

      /**
       * Get Upper and Lower Threshold inputs as values.
       */
      double GetUpper() const { return this->m_Upper; }\

      /**
       * Set/Get value to replace thresholded pixels. Pixels that lie * within Lower and Upper (inclusive) will be replaced with this value. The default is 1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetReplaceValue ( uint8_t ReplaceValue ) { this->m_ReplaceValue = ReplaceValue; return *this; }

      /**
       * Set/Get value to replace thresholded pixels. Pixels that lie * within Lower and Upper (inclusive) will be replaced with this value. The default is 1.
       */
      uint8_t GetReplaceValue() const { return this->m_ReplaceValue; }

      typedef enum {FaceConnectivity,FullConnectivity} ConnectivityType;\

      /**
       * Type of connectivity to use (fully connected OR 4(2D), 6(3D), 2*N(ND) connectivity).
       */
      SITK_RETURN_SELF_TYPE_HEADER SetConnectivity ( ConnectivityType Connectivity ) { this->m_Connectivity = Connectivity; return *this; }

      /**
       * Type of connectivity to use (fully connected OR 4(2D), 6(3D), 2*N(ND) connectivity).
       */
      ConnectivityType GetConnectivity() const { return this->m_Connectivity; }

      /** Name of this class */
      std::string GetName() const { return std::string ("ConnectedThresholdImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector< std::vector<unsigned int> >  m_SeedList{std::vector< std::vector<unsigned int > >()};

      double  m_Lower{0};

      double  m_Upper{1};

      /* Pixels that lie within Lower and Upper (inclusive)
will be replaced with this value. The default is 1. */
      uint8_t  m_ReplaceValue{1u};

      ConnectivityType  m_Connectivity{itk::simple::ConnectedThresholdImageFilter::FaceConnectivity};


    };

    /**\
     * \brief Label pixels that are connected to a seed and lie within a range of values.
     *
     * This function directly calls the execute method of ConnectedThresholdImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ConnectedThresholdImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image ConnectedThreshold ( const Image& image1, std::vector< std::vector<unsigned int> > seedList = std::vector< std::vector<unsigned int > >(), double lower = 0, double upper = 1, uint8_t replaceValue = 1u, ConnectedThresholdImageFilter::ConnectivityType connectivity = itk::simple::ConnectedThresholdImageFilter::FaceConnectivity );

     /** @} */
}
#endif
