/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.struct;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.StructModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.iterator.PStructUnpackIterator;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.struct.FormatAlignment;
import com.oracle.graal.python.builtins.objects.struct.FormatCode;
import com.oracle.graal.python.builtins.objects.struct.FormatDef;
import com.oracle.graal.python.builtins.objects.struct.PStruct;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.struct.StructNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PStruct})
public class StructBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = StructBuiltinsSlotsGen.SLOTS;

    static void packInternal(VirtualFrame frame, PStruct self, StructNodes.PackValueNode packValueNode, Object[] args, byte[] buffer, int offset) {
        assert (self.getSize() <= buffer.length - offset);
        FormatCode[] codes = self.getCodes();
        int pos = 0;
        for (FormatCode code : codes) {
            int buffer_offset = offset + code.offset;
            int j = 0;
            while (j < code.repeat) {
                packValueNode.execute(frame, code, self.formatAlignment, args[pos], buffer, buffer_offset);
                buffer_offset += code.size;
                ++j;
                ++pos;
            }
        }
    }

    public static Object[] unpackInternal(PStruct self, StructNodes.UnpackValueNode unpackValueNode, byte[] bytes, int offset) {
        Object[] values = new Object[self.getLen()];
        FormatCode[] codes = self.getCodes();
        int pos = 0;
        for (FormatCode code : codes) {
            int buffer_offset = offset + code.offset;
            int j = 0;
            while (j < code.repeat) {
                Object value;
                values[pos] = value = unpackValueNode.execute(code, self.formatAlignment, bytes, buffer_offset);
                buffer_offset += code.size;
                ++j;
                ++pos;
            }
        }
        return values;
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StructBuiltinsFactory.getFactories();
    }

    @Builtin(name="format", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetStructFormat
    extends PythonBuiltinNode {
        @Specialization
        protected Object get(PStruct self, @Cached TruffleString.FromByteArrayNode fromBytes, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            return switchEncoding.execute((AbstractTruffleString)fromBytes.execute(self.getFormat(), TruffleString.Encoding.US_ASCII), PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="size", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetStructSizeNode
    extends PythonBuiltinNode {
        @Specialization
        protected Object get(PStruct self) {
            return self.getSize();
        }
    }

    @Builtin(name="calcsize", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class StructCalcSizeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object calcSize(PStruct self) {
            return self.getSize();
        }
    }

    @Builtin(name="unpack_from", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer", "offset"}, forceSplitDirectCalls=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    public static abstract class StructUnpackFromNode
    extends PythonTernaryClinicBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PStruct var2, Object var3, int var4);

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StructBuiltinsClinicProviders.StructUnpackFromNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object unpackFrom(VirtualFrame frame, PStruct self, Object buffer, int offset, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached StructNodes.UnpackValueNode unpackValueNode, @Cached PRaiseNode raiseNode) {
            try {
                int bufferOffset = offset;
                int bytesLen = bufferLib.getBufferLength(buffer);
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                long size = self.getUnsignedSize();
                if (bufferOffset < 0) {
                    if ((long)bufferOffset + size > 0L) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_NOT_ENOUGH_DATA_TO_UNPACK_N_BYTES, size, bufferOffset);
                    }
                    if (bufferOffset + bytesLen < 0) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_OFFSET_OUT_OF_RANGE, bufferOffset, bytesLen);
                    }
                    bufferOffset += bytesLen;
                }
                if ((long)(bytesLen - bufferOffset) < size) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_UNPACK_FROM_REQ_AT_LEAST_N_BYTES, size + (long)bufferOffset, size, bufferOffset, bytesLen);
                }
                PTuple pTuple = PFactory.createTuple(language, StructBuiltins.unpackInternal(self, unpackValueNode, bytes, bufferOffset));
                return pTuple;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="iter_unpack", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer"}, forceSplitDirectCalls=true)
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    public static abstract class StructIterUnpackNode
    extends PythonBinaryClinicBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PStruct var2, Object var3);

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StructBuiltinsClinicProviders.StructIterUnpackNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(limit="3")
        static Object iterUnpack(VirtualFrame frame, PStruct self, Object buffer, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode raiseNode) {
            try {
                if (self.getSize() == 0) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_ITER_CANNOT_UNPACK_FROM_STRUCT_OF_SIZE_0);
                }
                int bufferLen = bufferLib.getBufferLength(buffer);
                if (bufferLen % self.getSize() != 0) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_ITER_UNPACK_REQ_A_BUFFER_OF_A_MUL_OF_BYTES, self.getSize());
                }
            }
            catch (Exception e) {
                bufferLib.release(buffer, frame, indirectCallData);
                throw e;
            }
            PStructUnpackIterator structUnpackIterator = PFactory.createStructUnpackIterator(language, self, buffer);
            structUnpackIterator.index = 0;
            return structUnpackIterator;
        }
    }

    @Builtin(name="unpack", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer"}, forceSplitDirectCalls=true)
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    public static abstract class StructUnpackNode
    extends PythonBinaryClinicBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PStruct var2, Object var3);

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StructBuiltinsClinicProviders.StructUnpackNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object unpack(VirtualFrame frame, PStruct self, Object buffer, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached StructNodes.UnpackValueNode unpackValueNode, @Cached PRaiseNode raiseNode) {
            try {
                int bytesLen = bufferLib.getBufferLength(buffer);
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                if (bytesLen != self.getSize()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.UNPACK_REQ_A_BUFFER_OF_N_BYTES, self.getSize());
                }
                PTuple pTuple = PFactory.createTuple(language, StructBuiltins.unpackInternal(self, unpackValueNode, bytes, 0));
                return pTuple;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="pack_into", minNumOfPositionalArgs=3, parameterNames={"$self", "buffer", "offset"}, takesVarArgs=true, forceSplitDirectCalls=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.WritableBuffer), @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    public static abstract class StructPackIntoNode
    extends PythonClinicBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PStruct var2, Object var3, int var4, Object[] var5);

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StructBuiltinsClinicProviders.StructPackIntoNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object packInto(VirtualFrame frame, PStruct self, Object buffer, int offset, Object[] args, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached StructNodes.PackValueNode packValueNode, @Cached PRaiseNode raiseNode) {
            try {
                long size = self.getUnsignedSize();
                if (args.length != self.getLen()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_PACK_EXPECTED_N_ITEMS_GOT_K, size, args.length);
                }
                int bufferOffset = offset;
                int bufferLen = bufferLib.getBufferLength(buffer);
                boolean directWrite = bufferLib.hasInternalByteArray(buffer);
                byte[] bytes = directWrite ? bufferLib.getInternalByteArray(buffer) : new byte[self.getSize()];
                if (bufferOffset < 0) {
                    if ((long)bufferOffset + size > 0L) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_NO_SPACE_TO_PACK_N_BYTES, size, bufferOffset);
                    }
                    if (bufferOffset + bufferLen < 0) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_OFFSET_OUT_OF_RANGE, bufferOffset, bufferLen);
                    }
                    bufferOffset += bufferLen;
                }
                if ((long)(bufferLen - bufferOffset) < size) {
                    assert (bufferOffset >= 0);
                    assert (size >= 0L);
                    throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_PACK_INTO_REQ_BUFFER_TO_PACK, size + (long)bufferOffset, size, bufferOffset, bufferLen);
                }
                StructBuiltins.packInternal(frame, self, packValueNode, args, bytes, directWrite ? bufferOffset : 0);
                if (!directWrite) {
                    bufferLib.writeFromByteArray(buffer, bufferOffset, bytes, 0, bytes.length);
                }
                PNone pNone = PNone.NONE;
                return pNone;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @NeverDefault
        public static StructPackIntoNode create() {
            return StructBuiltinsFactory.StructPackIntoNodeFactory.create(null);
        }
    }

    @Builtin(name="pack", minNumOfPositionalArgs=1, parameterNames={"$self"}, takesVarArgs=true, takesVarKeywordArgs=true, forceSplitDirectCalls=true)
    @GenerateNodeFactory
    public static abstract class StructPackNode
    extends PythonVarargsBuiltinNode {
        public final Object execute(VirtualFrame frame, PStruct self, Object[] args) {
            return this.execute(frame, self, args, PKeyword.EMPTY_KEYWORDS);
        }

        @Specialization
        static Object pack(VirtualFrame frame, PStruct self, Object[] args, PKeyword[] keywords, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached StructNodes.PackValueNode packValueNode, @Cached PRaiseNode raiseNode) {
            if (keywords.length != 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "pack()");
            }
            if (args.length != self.getLen()) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.StructError, ErrorMessages.STRUCT_PACK_EXPECTED_N_ITEMS_GOT_K, self.getLen(), args.length);
            }
            byte[] bytes = new byte[self.getSize()];
            StructBuiltins.packInternal(frame, self, packValueNode, args, bytes, 0);
            return PFactory.createBytes(language, bytes);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="Struct", minNumOfPositionalArgs=2)
    @ImportStatic(value={PythonUtils.class})
    @GenerateNodeFactory
    public static abstract class ConstructStructNode
    extends PythonBinaryBuiltinNode {
        public static final int NUM_BYTES_LIMIT;
        private static final int SHORT_ALIGN = 2;
        private static final int INT_ALIGN = 4;
        private static final int LONG_ALIGN = 8;
        private static final int FLOAT_ALIGN = 4;
        private static final int DOUBLE_ALIGN = 8;
        private static final char ALIGNMENT_NATIVE_NATIVE = '@';
        private static final char ALIGNMENT_NATIVE_STD = '=';
        private static final char ALIGNMENT_LE_STD = '<';
        private static final char ALIGNMENT_BE_STD = '>';
        private static final char ALIGNMENT_NET_BE_STD = '!';
        private static final char DEFAULT_ALIGNMENT = '@';
        private static final FormatDef[] FMT_TABLE;
        private static final FormatDef[] FMT_TABLE_NATIVE;

        static void setFormatDefEntry(FormatDef[] table, char format, TruffleString label, int size, Set<Integer> numBytes) {
            ConstructStructNode.setFormatDefEntry(table, format, label, size, 0, numBytes);
        }

        static void setFormatDefEntry(FormatDef[] table, char format, TruffleString label, int size, int alignment, Set<Integer> numBytes) {
            table[format] = new FormatDef(format, label, size, alignment);
            numBytes.add(size);
        }

        public final PStruct execute(Object format) {
            return this.execute((Object)PythonBuiltinClassType.PStruct, format);
        }

        public abstract PStruct execute(Object var1, Object var2);

        @Specialization(guards={"isAscii(format, getCodeRangeNode)"})
        static PStruct struct(Object cls, TruffleString format, @Bind Node inliningTarget, @Cached.Shared @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached TruffleString.GetCodeRangeNode getCodeRangeNode) {
            byte[] fmt = PythonUtils.getAsciiBytes(format, copyToByteArrayNode, switchEncodingNode);
            return PFactory.createStruct(PythonLanguage.get(inliningTarget), ConstructStructNode.createStructInternal(inliningTarget, fmt));
        }

        @Specialization
        static PStruct struct(Object cls, PString format, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached.Shared @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached TruffleString.GetCodeRangeNode getCodeRangeNode) {
            return ConstructStructNode.struct(cls, castToTruffleStringNode.execute(inliningTarget, format), inliningTarget, copyToByteArrayNode, switchEncodingNode, getCodeRangeNode);
        }

        @Specialization(limit="1")
        static PStruct struct(Object cls, PBytes format, @Bind Node inliningTarget, @CachedLibrary(value="format") PythonBufferAccessLibrary bufferLib) {
            byte[] fmt = bufferLib.getCopiedByteArray(format);
            return PFactory.createStruct(PythonLanguage.get(inliningTarget), ConstructStructNode.createStructInternal(inliningTarget, fmt));
        }

        @Specialization(guards={"!isPBytes(format)", "!isPString(format)", "!isAsciiTruffleString(format, getCodeRangeNode)"})
        static PStruct fallback(Object cls, Object format, @Cached.Shared @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.StructError, ErrorMessages.ARG_MUST_BE_STR_OR_BYTES, "Struct()", format);
        }

        protected static boolean isAsciiTruffleString(Object o, TruffleString.GetCodeRangeNode getCodeRangeNode) {
            return o instanceof TruffleString && PythonUtils.isAscii((TruffleString)o, getCodeRangeNode);
        }

        @CompilerDirectives.TruffleBoundary
        private static PStruct.StructInfo createStructInternal(Node raisingNode, byte[] format) {
            int num;
            int size = 0;
            int len = 0;
            int nCodes = 0;
            if (StructModuleBuiltins.containsNullCharacter(format)) {
                throw PRaiseNode.raiseStatic(raisingNode, PythonBuiltinClassType.StructError, ErrorMessages.EMBEDDED_NULL_CHARACTER);
            }
            char alignment = '@';
            int start = 0;
            if (format.length > 0 && ConstructStructNode.isAlignment((char)format[0])) {
                alignment = (char)format[0];
                start = 1;
            }
            FormatAlignment formatAlignment = ConstructStructNode.whichAlignment(alignment);
            FormatDef[] formatTable = formatAlignment.nativeSizing ? FMT_TABLE_NATIVE : FMT_TABLE;
            for (int i = start; i < format.length; ++i) {
                char c = (char)format[i];
                if (c == ' ') continue;
                if ('0' <= c && c <= '9') {
                    num = c - 48;
                    while (++i < format.length && '0' <= (c = (char)format[i]) && c <= '9') {
                        if (num >= 0xCCCCCCC && (num > 0xCCCCCCC || c - 48 > 7)) {
                            throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.StructError, ErrorMessages.STRUCT_SIZE_TOO_LONG);
                        }
                        num = num * 10 + (c - 48);
                    }
                    if (i == format.length) {
                        throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.StructError, ErrorMessages.REPEAT_COUNT_WITHOUT_FMT);
                    }
                } else {
                    num = 1;
                }
                FormatDef formatDef = ConstructStructNode.getEntry(raisingNode, c, formatTable);
                switch (c) {
                    case 'p': 
                    case 's': {
                        ++len;
                        ++nCodes;
                        break;
                    }
                    case 'x': {
                        break;
                    }
                    default: {
                        len += num;
                        if (num == 0) break;
                        ++nCodes;
                    }
                }
                int itemSize = formatDef.size;
                size = ConstructStructNode.align(size, c, formatDef);
                if (size == -1) {
                    throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.StructError, ErrorMessages.STRUCT_SIZE_TOO_LONG);
                }
                if (num > (Integer.MAX_VALUE - size) / itemSize) {
                    throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.StructError, ErrorMessages.STRUCT_SIZE_TOO_LONG);
                }
                size += num * itemSize;
            }
            FormatCode[] codes = new FormatCode[nCodes];
            int structSize = size;
            int structLen = len;
            int j = 0;
            size = 0;
            for (int i = start; i < format.length; ++i) {
                char c = (char)format[i];
                if (c == ' ') continue;
                if ('0' <= c && c <= '9') {
                    num = c - 48;
                    while (++i < format.length && '0' <= (c = (char)format[i]) && c <= '9') {
                        num = num * 10 + (c - 48);
                    }
                } else {
                    num = 1;
                }
                FormatDef formatDef = ConstructStructNode.getEntry(raisingNode, c, formatTable);
                size = ConstructStructNode.align(size, c, formatDef);
                if (c == 's' || c == 'p') {
                    codes[j++] = new FormatCode(formatDef, size, num, 1);
                    size += num;
                    continue;
                }
                if (c == 'x') {
                    size += num;
                    continue;
                }
                if (num == 0) continue;
                codes[j++] = new FormatCode(formatDef, size, formatDef.size, num);
                size += formatDef.size * num;
            }
            return new PStruct.StructInfo(format, structSize, structLen, formatAlignment, codes);
        }

        private static FormatDef getEntry(Node raisingNode, char format, FormatDef[] table) {
            FormatDef formatDef = table[format];
            if (formatDef != null) {
                return formatDef;
            }
            throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.StructError, ErrorMessages.BAD_CHR_IN_STRUCT_FMT, Character.valueOf(format));
        }

        private static boolean isAlignment(char alignment) {
            return alignment == '<' || alignment == '>' || alignment == '!' || alignment == '=' || alignment == '@';
        }

        private static FormatAlignment whichAlignment(char alignment) {
            switch (alignment) {
                case '<': {
                    return new FormatAlignment(false, false);
                }
                case '!': 
                case '>': {
                    return new FormatAlignment(true, false);
                }
                case '=': {
                    return new FormatAlignment(ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN, false);
                }
            }
            return new FormatAlignment(ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN, true);
        }

        private static int align(int size, char c, FormatDef formatDef) {
            int alignedSize = size;
            if (formatDef.format == c && formatDef.alignment > 0 && alignedSize > 0) {
                int extra = formatDef.alignment - 1 - (alignedSize - 1) % formatDef.alignment;
                if (extra > Integer.MAX_VALUE - alignedSize) {
                    return -1;
                }
                alignedSize += extra;
            }
            return alignedSize;
        }

        static {
            FMT_TABLE = new FormatDef[128];
            FMT_TABLE_NATIVE = new FormatDef[128];
            HashSet<Integer> numBytes = new HashSet<Integer>();
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'x', FormatCode.T_LBL_PAD_BYTE, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'b', FormatCode.T_LBL_SIGNED_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'B', FormatCode.T_LBL_UNSIGNED_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'c', FormatCode.T_LBL_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 's', FormatCode.T_LBL_STRING, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'p', FormatCode.T_LBL_PASCAL_STRING, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'h', FormatCode.T_LBL_SHORT, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'H', FormatCode.T_LBL_UNSIGNED_SHORT, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'i', FormatCode.T_LBL_INT, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'I', FormatCode.T_LBL_UNSIGNED_INT, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'l', FormatCode.T_LBL_LONG, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'L', FormatCode.T_LBL_UNSIGNED_LONG, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'q', FormatCode.T_LBL_LONG_LONG, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'Q', FormatCode.T_LBL_UNSIGNED_LONG_LONG, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, '?', FormatCode.T_LBL_BOOL, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'e', FormatCode.T_LBL_HALF_FLOAT, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'f', FormatCode.T_LBL_FLOAT, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'd', FormatCode.T_LBL_DOUBLE, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'x', FormatCode.T_LBL_PAD_BYTE, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'b', FormatCode.T_LBL_SIGNED_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'B', FormatCode.T_LBL_UNSIGNED_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'c', FormatCode.T_LBL_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 's', FormatCode.T_LBL_STRING, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'p', FormatCode.T_LBL_PASCAL_STRING, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'h', FormatCode.T_LBL_SHORT, 2, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'H', FormatCode.T_LBL_UNSIGNED_SHORT, 2, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'i', FormatCode.T_LBL_INT, 4, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'I', FormatCode.T_LBL_UNSIGNED_INT, 4, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'l', FormatCode.T_LBL_LONG, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? 4 : 8, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? 4 : 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'L', FormatCode.T_LBL_UNSIGNED_LONG, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? 4 : 8, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? 4 : 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'n', FormatCode.T_LBL_SIZE_T, 8, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'N', FormatCode.T_LBL_UNSIGNED_SIZE_T, 8, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'q', FormatCode.T_LBL_LONG_LONG, 8, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'Q', FormatCode.T_LBL_UNSIGNED_LONG_LONG, 8, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, '?', FormatCode.T_LBL_BOOL, 1, 0, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'e', FormatCode.T_LBL_HALF_FLOAT, 2, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'f', FormatCode.T_LBL_FLOAT, 4, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'd', FormatCode.T_LBL_DOUBLE, 8, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'P', FormatCode.T_LBL_VOID_PTR, 8, 8, numBytes);
            NUM_BYTES_LIMIT = numBytes.size();
        }
    }
}

