/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecState;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteEncodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalEncoderBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalEncoderBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalEncoderBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalEncoderObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStatefulEncoderContext;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.ints.IntNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MultibyteIncrementalEncoder})
public final class MultibyteIncrementalEncoderBuiltins
extends PythonBuiltins {
    private static final int MAXENCPENDING = 2;
    public static final TpSlots SLOTS = MultibyteIncrementalEncoderBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultibyteIncrementalEncoderBuiltinsFactory.getFactories();
    }

    @Builtin(name="reset", minNumOfPositionalArgs=1, parameterNames={"$self"}, doc="reset($self, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class ResetNode
    extends PythonUnaryBuiltinNode {
        private static final MultibyteEncodeBuffer SINK = new MultibyteEncodeBuffer(4);

        ResetNode() {
        }

        @Specialization
        static Object reset(MultibyteIncrementalEncoderObject self) {
            if (self.codec.canEncreset()) {
                self.codec.encreset(self.state, SINK);
                SINK.rewindOutbuf();
            }
            self.pending = null;
            return PNone.NONE;
        }
    }

    @Builtin(name="setstate", parameterNames={"$self", "state"}, doc="setstate($self, state, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        SetStateNode() {
        }

        @Specialization
        static Object setstate(MultibyteIncrementalEncoderObject self, PInt statelong, @Bind Node inliningTarget, @Cached HiddenAttr.ReadNode readHiddenAttrNode, @Cached IntNodes.PyLongAsByteArray asByteArray, @Cached PRaiseNode raiseNode) {
            int sizeOfStateBytes = 17;
            byte[] statebytes = asByteArray.execute(inliningTarget, statelong, sizeOfStateBytes, false);
            if (statebytes[0] > 8) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.UnicodeError, ErrorMessages.PENDING_BUFFER_TOO_LARGE);
            }
            self.pending = SetStateNode.decodeUTF8(statebytes, 1, statebytes[0]);
            Object s = readHiddenAttrNode.execute(inliningTarget, statelong, HiddenAttr.ENCODER_OBJECT, null);
            assert (s == null || s instanceof MultibyteCodecState) : "Not MultibyteCodecState object!";
            self.state = (MultibyteCodecState)s;
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString decodeUTF8(byte[] buf, int off, int len) {
            ByteBuffer in = ByteBuffer.wrap(buf, off, len);
            CharBuffer out = CharBuffer.allocate(len * 4);
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(in, out, true);
            return TruffleString.fromCharArrayUTF16Uncached((char[])out.array());
        }
    }

    @Builtin(name="getstate", minNumOfPositionalArgs=1, parameterNames={"$self"}, doc="getstate($self, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class GetStateNode
    extends PythonUnaryBuiltinNode {
        GetStateNode() {
        }

        @Specialization
        static Object getstate(MultibyteIncrementalEncoderObject self, @Bind Node inliningTarget, @Cached HiddenAttr.WriteNode writeHiddenAttrNode, @Cached CodecsModuleBuiltins.CodecsEncodeToJavaBytesNode asUTF8AndSize, @Cached IntNodes.PyLongFromByteArray fromByteArray, @Cached PRaiseNode raiseNode) {
            byte[] statebytes = new byte[17];
            statebytes[0] = 0;
            if (self.pending != null) {
                byte[] pendingbuffer = asUTF8AndSize.execute(self.pending, StringLiterals.T_UTF8, StringLiterals.T_STRICT);
                int pendingsize = pendingbuffer.length;
                if (pendingsize > 8) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.UnicodeError, ErrorMessages.PENDING_BUFFER_TOO_LARGE);
                }
                statebytes[0] = (byte)pendingsize;
                PythonUtils.arraycopy(pendingbuffer, 0, statebytes, 1, pendingsize);
            }
            Object stateobj = fromByteArray.execute(inliningTarget, statebytes, true, true);
            assert (stateobj instanceof PInt);
            writeHiddenAttrNode.execute(inliningTarget, (PInt)stateobj, HiddenAttr.ENCODER_OBJECT, self.state);
            return stateobj;
        }
    }

    @Builtin(name="encode", minNumOfPositionalArgs=1, parameterNames={"$self", "input", "final"}, doc="encode($self, /, input, final=False)\n--\n\n")
    @ArgumentClinic(name="final", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class EncodeNode
    extends PythonTernaryClinicBuiltinNode {
        EncodeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteIncrementalEncoderBuiltinsClinicProviders.EncodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object encode(VirtualFrame frame, MultibyteStatefulEncoderContext ctx, Object unistr, int end, @Cached EncodeStatefulNode encodeStatefulNode) {
            return encodeStatefulNode.execute(frame, ctx, unistr, end);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    protected static abstract class EncodeStatefulNode
    extends Node {
        protected EncodeStatefulNode() {
        }

        abstract Object execute(VirtualFrame var1, MultibyteStatefulEncoderContext var2, Object var3, int var4);

        @Specialization
        static Object ts(VirtualFrame frame, MultibyteStatefulEncoderContext ctx, TruffleString ucvt, int end, @Bind Node inliningTarget, @Cached.Exclusive @Cached MultibyteCodecUtil.EncodeNode encodeNode, @Cached.Shared @Cached TruffleString.ConcatNode concatNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.SubstringNode substringNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            PBytes r;
            TruffleString inbuf = ucvt;
            TruffleString origpending = null;
            if (ctx.pending != null) {
                origpending = ctx.pending;
                inbuf = concatNode.execute((AbstractTruffleString)ctx.pending, (AbstractTruffleString)ucvt, PythonUtils.TS_ENCODING, false);
                ctx.pending = null;
            }
            int datalen = codePointLengthNode.execute((AbstractTruffleString)inbuf, PythonUtils.TS_ENCODING);
            try {
                r = MultibyteCodecUtil.encodeEmptyInput(inliningTarget, datalen, 3);
                if (r == null) {
                    MultibyteEncodeBuffer buf = new MultibyteEncodeBuffer(inbuf);
                    r = encodeNode.execute(frame, inliningTarget, ctx.codec, ctx.state, buf, ctx.errors, end != 0 ? 3 : 0);
                    if (buf.getInpos() < datalen) {
                        if (datalen - buf.getInpos() > 2) {
                            throw raiseNode.raise(inliningTarget, PythonErrorType.UnicodeError, ErrorMessages.PENDING_BUFFER_OVERFLOW);
                        }
                        ctx.pending = substringNode.execute((AbstractTruffleString)inbuf, buf.getInpos(), datalen, PythonUtils.TS_ENCODING, false);
                    }
                }
            }
            catch (Exception e) {
                ctx.pending = origpending;
                throw e;
            }
            return r;
        }

        @Specialization(guards={"!isTruffleString(unistr)"})
        static Object notTS(VirtualFrame frame, MultibyteStatefulEncoderContext ctx, Object unistr, int end, @Bind Node inliningTarget, @Cached PyObjectStrAsObjectNode strNode, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached CastToTruffleStringNode toTruffleStringNode, @Cached.Exclusive @Cached MultibyteCodecUtil.EncodeNode encodeNode, @Cached.Shared @Cached TruffleString.ConcatNode concatNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.SubstringNode substringNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object ucvt = unistr;
            if (!unicodeCheckNode.execute(inliningTarget, unistr)) {
                ucvt = strNode.execute((Frame)frame, inliningTarget, unistr);
                if (!unicodeCheckNode.execute(inliningTarget, unistr)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.COULDN_T_CONVERT_THE_OBJECT_TO_STR);
                }
            }
            TruffleString str = toTruffleStringNode.execute(inliningTarget, ucvt);
            return EncodeStatefulNode.ts(frame, ctx, str, end, inliningTarget, encodeNode, concatNode, codePointLengthNode, substringNode, raiseNode);
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="MultibyteIncrementalEncoder", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone init(MultibyteIncrementalEncoderObject self) {
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, parameterNames={"$cls", "errors"})
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBinaryBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        static Object mbstreamreaderNew(VirtualFrame frame, Object type, Object err, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached PyObjectGetAttr getAttr, @Cached TruffleString.EqualNode isEqual, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            TruffleString errors = null;
            if (err != PNone.NO_VALUE) {
                errors = castToStringNode.execute(inliningTarget, err);
            }
            MultibyteIncrementalEncoderObject self = PFactory.createMultibyteIncrementalEncoderObject(language, type, getInstanceShape.execute(type));
            Object codec = getAttr.execute((Frame)frame, inliningTarget, type, StringLiterals.T_CODEC);
            if (!(codec instanceof MultibyteCodecObject)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CODEC_IS_UNEXPECTED_TYPE);
            }
            self.codec = ((MultibyteCodecObject)codec).codec;
            self.pending = null;
            self.errors = MultibyteCodecUtil.internalErrorCallback(errors, isEqual);
            self.codec.encinit(self.errors);
            return self;
        }
    }
}

