#  Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

import abc

class ReversibleProxy: ...

class StartableContext(abc.ABC, metaclass=abc.ABCMeta):
    @abc.abstractmethod
    async def start(self, is_ctxmanager: bool = ...): ...
    def __await__(self): ...
    async def __aenter__(self): ...
    @abc.abstractmethod
    async def __aexit__(self, type_, value, traceback): ...

class ProxyComparable(ReversibleProxy):
    def __hash__(self): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
