/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.util.NumericUtils;

class DocScoreEncoder {
    static final long LEAST_COMPETITIVE_CODE = DocScoreEncoder.encode(Integer.MAX_VALUE, Float.NEGATIVE_INFINITY);

    DocScoreEncoder() {
    }

    static long encode(int docId, float score) {
        return (long)NumericUtils.floatToSortableInt(score) << 32 | (long)(Integer.MAX_VALUE - docId);
    }

    static float toScore(long value) {
        return NumericUtils.sortableIntToFloat((int)(value >>> 32));
    }

    static int docId(long value) {
        return Integer.MAX_VALUE - (int)value;
    }
}

