/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.util.regex;

import ai.grazie.rules.util.regex.Literal;
import ai.grazie.rules.util.regex.PathComponent;
import ai.grazie.rules.util.regex.Unsupported;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

record RegexPath(List<PathComponent> components) {
    RegexPath {
        assert (!components.isEmpty());
    }

    @Nullable
    PathComponent single() {
        return this.components.size() == 1 ? this.components.get(0) : null;
    }

    RegexPath concat(RegexPath next) {
        PathComponent nextFirst;
        ArrayList<PathComponent> result = new ArrayList<PathComponent>(this.components.subList(0, this.components.size() - 1));
        PathComponent myLast = this.components.get(this.components.size() - 1);
        PathComponent merged = myLast.merge(nextFirst = next.components.get(0));
        if (merged != null) {
            result.add(merged);
        } else {
            result.add(myLast);
            result.add(nextFirst);
        }
        result.addAll(next.components.subList(1, next.components.size()));
        return new RegexPath(result);
    }

    @Nullable
    @Nullable Function<String, @Nullable Boolean> matcher(boolean caseSensitive) {
        Unsupported u;
        PathComponent single = this.single();
        if (this.components.size() == 2 || single instanceof Unsupported && RegexPath.isMinLengthCheckEnough(u = (Unsupported)single)) {
            boolean startWithLiteral = this.components.get(0) instanceof Literal;
            String literal = single != null ? null : ((Literal)this.components.get(startWithLiteral ? 0 : 1)).value();
            Unsupported gap = (Unsupported)this.components.get(single == null && startWithLiteral ? 1 : 0);
            boolean isSufficient = RegexPath.isMinLengthCheckEnough(gap);
            int minLength = (literal == null ? 0 : literal.length()) + gap.minLength();
            return s -> {
                if (literal != null) {
                    boolean literalMatches;
                    boolean bl = startWithLiteral ? s.regionMatches(!caseSensitive, 0, literal, 0, literal.length()) : (literalMatches = s.regionMatches(!caseSensitive, s.length() - literal.length(), literal, 0, literal.length()));
                    if (!literalMatches) {
                        return false;
                    }
                }
                return isSufficient ? Boolean.valueOf(s.length() >= minLength) : null;
            };
        }
        return null;
    }

    private static boolean isMinLengthCheckEnough(Unsupported u) {
        return u.anyChars() && !u.bounded() && u.minLength() <= 1;
    }

    static RegexPath toUnsupported(Set<RegexPath> paths) {
        return new RegexPath(List.of(new Unsupported(paths.stream().mapToInt(path -> path.components().stream().mapToInt(PathComponent::minLength).sum()).min().orElseThrow(), paths.stream().allMatch(path -> path.components().stream().allMatch(PathComponent::bounded)), paths.stream().allMatch(path -> {
            Unsupported u;
            PathComponent patt0$temp = path.single();
            return patt0$temp instanceof Unsupported && (u = (Unsupported)patt0$temp).anyChars();
        }))));
    }
}

