/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.FilterBlurMode;
import org.jetbrains.skia.MaskFilterKt;
import org.jetbrains.skia.Shader;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Library;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.RefCnt;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0015\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/skia/MaskFilter;", "Lorg/jetbrains/skia/impl/RefCnt;", "ptr", "Lorg/jetbrains/skia/impl/NativePointer;", "", "<init>", "(J)V", "Companion", "skiko"})
public final class MaskFilter
extends RefCnt {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MaskFilter(long ptr) {
        super(ptr);
    }

    static {
        Library.Companion.staticLoad();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\tJ\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/skia/MaskFilter$Companion;", "", "<init>", "()V", "makeBlur", "Lorg/jetbrains/skia/MaskFilter;", "mode", "Lorg/jetbrains/skia/FilterBlurMode;", "sigma", "", "respectCTM", "", "makeShader", "s", "Lorg/jetbrains/skia/Shader;", "makeTable", "table", "", "makeGamma", "gamma", "makeClip", "min", "", "max", "convertRadiusToSigma", "radius", "convertSigmaToRadius", "skiko"})
    @SourceDebugExtension(value={"SMAP\nMaskFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaskFilter.kt\norg/jetbrains/skia/MaskFilter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Native.jvm.kt\norg/jetbrains/skia/impl/Native_jvmKt\n*L\n1#1,84:1\n1#2:85\n55#3:86\n*S KotlinDebug\n*F\n+ 1 MaskFilter.kt\norg/jetbrains/skia/MaskFilter$Companion\n*L\n39#1:86\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MaskFilter makeBlur(@NotNull FilterBlurMode mode, float sigma, boolean respectCTM) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Stats.INSTANCE.onNativeCall();
            return new MaskFilter(MaskFilterKt.access$_nMakeBlur(mode.ordinal(), sigma, respectCTM));
        }

        public static /* synthetic */ MaskFilter makeBlur$default(Companion companion, FilterBlurMode filterBlurMode, float f, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.makeBlur(filterBlurMode, f, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final MaskFilter makeShader(@Nullable Shader s) {
            MaskFilter maskFilter;
            try {
                Stats.INSTANCE.onNativeCall();
                maskFilter = new MaskFilter(MaskFilterKt.access$_nMakeShader(NativeKt.getPtr(s)));
            }
            finally {
                Native_jvmKt.reachabilityBarrier(s);
            }
            return maskFilter;
        }

        @NotNull
        public final MaskFilter makeTable(@NotNull byte[] table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            if (!(table.length == 256)) {
                boolean $i$a$-require-MaskFilter$Companion$makeTable$22 = false;
                String $i$a$-require-MaskFilter$Companion$makeTable$22 = "Expected 256 elements, got " + table.length;
                throw new IllegalArgumentException($i$a$-require-MaskFilter$Companion$makeTable$22.toString());
            }
            Stats.INSTANCE.onNativeCall();
            boolean $i$f$interopScope = false;
            InteropScope $this$makeTable_u24lambda_u241 = theScope.INSTANCE;
            boolean bl = false;
            long l = MaskFilterKt.access$MaskFilter_nMakeTable($this$makeTable_u24lambda_u241.toInterop(table));
            return new MaskFilter(l);
        }

        @NotNull
        public final MaskFilter makeGamma(float gamma) {
            Stats.INSTANCE.onNativeCall();
            return new MaskFilter(MaskFilterKt.access$_nMakeGamma(gamma));
        }

        @NotNull
        public final MaskFilter makeClip(int min, int max) {
            Stats.INSTANCE.onNativeCall();
            return new MaskFilter(MaskFilterKt.access$_nMakeClip((byte)min, (byte)max));
        }

        public final float convertRadiusToSigma(float radius) {
            return radius > 0.0f ? 0.57735f * radius + 0.5f : 0.0f;
        }

        public final float convertSigmaToRadius(float sigma) {
            return sigma > 0.5f ? (sigma - 0.5f) / 0.57735f : 0.0f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

