/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.model.DomModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class DomModelImpl<T extends DomElement>
implements DomModel<T> {
    protected final DomFileElement<T> myMergedModel;
    protected final Set<XmlFile> myConfigFiles;
    private Class<T> myClass;
    private Project myProject;

    public DomModelImpl(DomFileElement<T> mergedModel, @NotNull Set<XmlFile> configFiles) {
        if (configFiles == null) {
            DomModelImpl.$$$reportNull$$$0(0);
        }
        this.myMergedModel = DomUtil.getFileElement(mergedModel);
        this.myConfigFiles = configFiles;
    }

    public DomModelImpl(@NotNull Set<XmlFile> configFiles, Class<T> clazz, Project project) {
        if (configFiles == null) {
            DomModelImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myMergedModel = null;
        this.myConfigFiles = configFiles;
        this.myClass = clazz;
    }

    @Override
    @NotNull
    public T getMergedModel() {
        if (this.myMergedModel == null) {
            DomManager domManager = DomManager.getDomManager(this.myProject);
            DomElement domElement = (DomElement)domManager.createModelMerger().mergeModels(this.myClass, ContainerUtil.mapNotNull(this.myConfigFiles, (Function)((NullableFunction)xmlFile -> {
                DomFileElement<T> fileElement = domManager.getFileElement((XmlFile)xmlFile, this.myClass);
                return fileElement == null ? null : (DomElement)fileElement.getRootElement();
            })));
            if (domElement == null) {
                DomModelImpl.$$$reportNull$$$0(2);
            }
            return (T)domElement;
        }
        T t = this.myMergedModel.getRootElement();
        if (t == null) {
            DomModelImpl.$$$reportNull$$$0(3);
        }
        return t;
    }

    @Override
    @NotNull
    public Set<XmlFile> getConfigFiles() {
        Set<XmlFile> set = this.myConfigFiles;
        if (set == null) {
            DomModelImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public @Unmodifiable @NotNull List<DomFileElement<T>> getRoots() {
        if (this.myMergedModel == null) {
            List list = ContainerUtil.mapNotNull(this.myConfigFiles, (Function)((NullableFunction)xmlFile -> DomManager.getDomManager(xmlFile.getProject()).getFileElement((XmlFile)xmlFile, this.myClass)));
            if (list == null) {
                DomModelImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<DomFileElement<Object>> list = this.myMergedModel instanceof MergedObject ? ((MergedObject)((Object)this.myMergedModel)).getImplementations() : Collections.singletonList(this.myMergedModel);
        if (list == null) {
            DomModelImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DomModelImpl.$$$reportNull$$$0(7);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/model/impl/DomModelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/model/impl/DomModelImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

