/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\nJ\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/EventsSchemeConfigurationModel;", "", "<init>", "()V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "recorderToSettings", "", "", "Lcom/intellij/internal/statistic/devkit/actions/EventsSchemeConfigurationModel$EventsSchemePathSettings;", "getRecorderToSettings", "()Ljava/util/Map;", "recorderComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "useCustomPathCheckBox", "Ljavax/swing/JCheckBox;", "currentSettings", "updatePathField", "", "updatePanel", "reset", "recorderId", "validate", "Lcom/intellij/openapi/ui/ValidationInfo;", "validatePath", "settings", "EventsSchemePathSettings", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nEventsSchemeConfigurationModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsSchemeConfigurationModel.kt\ncom/intellij/internal/statistic/devkit/actions/EventsSchemeConfigurationModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1563#2:140\n1634#2,3:141\n*S KotlinDebug\n*F\n+ 1 EventsSchemeConfigurationModel.kt\ncom/intellij/internal/statistic/devkit/actions/EventsSchemeConfigurationModel\n*L\n30#1:140\n30#1:141,3\n*E\n"})
public final class EventsSchemeConfigurationModel {
    @NotNull
    private final DialogPanel panel;
    @NotNull
    private final Map<String, EventsSchemePathSettings> recorderToSettings = new LinkedHashMap();
    private ComboBox<String> recorderComboBox;
    @NotNull
    private final TextFieldWithBrowseButton pathField = new TextFieldWithBrowseButton();
    private JCheckBox useCustomPathCheckBox;
    @Nullable
    private EventsSchemePathSettings currentSettings;

    public EventsSchemeConfigurationModel() {
        this.panel = BuilderKt.panel(arg_0 -> EventsSchemeConfigurationModel._init_$lambda$0(this, arg_0));
        this.pathField.addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle("Select Events Scheme Location"));
        this.updatePanel();
    }

    @NotNull
    public final DialogPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final Map<String, EventsSchemePathSettings> getRecorderToSettings() {
        return this.recorderToSettings;
    }

    private final void updatePathField() {
        JCheckBox jCheckBox = this.useCustomPathCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomPathCheckBox");
            jCheckBox = null;
        }
        boolean useCustomPath = jCheckBox.isSelected();
        EventsSchemePathSettings settings = this.currentSettings;
        if (settings == null) {
            return;
        }
        this.pathField.setEditable(useCustomPath);
        this.pathField.setEnabled(useCustomPath);
        this.pathField.setText(settings.getCurrentPath());
    }

    private final void updatePanel() {
        EventsSchemePathSettings settings;
        ComboBox<String> comboBox = this.recorderComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderComboBox");
            comboBox = null;
        }
        Object object = comboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String recorderId = (String)object;
        EventsSchemePathSettings eventsSchemePathSettings = this.recorderToSettings.computeIfAbsent(recorderId, arg_0 -> EventsSchemeConfigurationModel.updatePanel$lambda$1(arg_0 -> EventsSchemeConfigurationModel.updatePanel$lambda$0(recorderId, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)eventsSchemePathSettings, (String)"computeIfAbsent(...)");
        this.currentSettings = settings = eventsSchemePathSettings;
        JCheckBox jCheckBox = this.useCustomPathCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomPathCheckBox");
            jCheckBox = null;
        }
        jCheckBox.setSelected(settings.getUseCustomPath());
        this.updatePathField();
    }

    @NotNull
    public final EventsSchemeConfigurationModel reset(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        ComboBox<String> comboBox = this.recorderComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderComboBox");
            comboBox = null;
        }
        comboBox.setSelectedItem((Object)recorderId);
        return this;
    }

    @Nullable
    public final ValidationInfo validate() {
        EventsSchemePathSettings eventsSchemePathSettings = this.currentSettings;
        if (eventsSchemePathSettings == null) {
            return null;
        }
        EventsSchemePathSettings currentPathSettings = eventsSchemePathSettings;
        ValidationInfo currentValidationInfo = this.validatePath(currentPathSettings);
        if (currentValidationInfo != null) {
            return currentValidationInfo;
        }
        for (Map.Entry<String, EventsSchemePathSettings> entry : this.recorderToSettings.entrySet()) {
            ValidationInfo validationInfo;
            String recorder = entry.getKey();
            EventsSchemePathSettings settings = entry.getValue();
            if (Intrinsics.areEqual((Object)settings, (Object)this.currentSettings) || (validationInfo = this.validatePath(settings)) == null) continue;
            ComboBox<String> comboBox = this.recorderComboBox;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderComboBox");
                comboBox = null;
            }
            comboBox.setSelectedItem((Object)recorder);
            this.updatePanel();
            return validationInfo;
        }
        return null;
    }

    private final ValidationInfo validatePath(EventsSchemePathSettings settings) {
        if (!settings.getUseCustomPath()) {
            return null;
        }
        String customPath = settings.getCustomPath();
        CharSequence charSequence = customPath;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new ValidationInfo("Specify events scheme path.", (JComponent)this.pathField.getTextField());
        }
        if (!FileUtil.exists((String)customPath)) {
            return new ValidationInfo("File doesn't exist.", (JComponent)this.pathField.getTextField());
        }
        return null;
    }

    private static final Unit _init_$lambda$0(EventsSchemeConfigurationModel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row("Recorder:", arg_0 -> EventsSchemeConfigurationModel.lambda$0$0(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> EventsSchemeConfigurationModel.lambda$0$1(this$0, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$0$0(EventsSchemeConfigurationModel this$0, Row $this$row) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Iterable iterable = StatisticsDevKitUtil.INSTANCE.getLogProvidersInTestMode();
        Row row = $this$row;
        EventsSchemeConfigurationModel eventsSchemeConfigurationModel = this$0;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StatisticsEventLoggerProvider statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRecorderId());
        }
        collection = (List)destination$iv$iv;
        eventsSchemeConfigurationModel.recorderComboBox = (ComboBox)Row.comboBox$default((Row)row, (Collection)collection, null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).onChanged(arg_0 -> EventsSchemeConfigurationModel.lambda$0$0$1(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$1(EventsSchemeConfigurationModel this$0, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updatePanel();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(EventsSchemeConfigurationModel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.useCustomPathCheckBox = (JCheckBox)$this$row.checkBox("Use custom path:").onChanged(arg_0 -> EventsSchemeConfigurationModel.lambda$0$1$0(this$0, arg_0)).getComponent();
        $this$row.cell((JComponent)this$0.pathField).align((Align)AlignX.FILL.INSTANCE).onChanged(arg_0 -> EventsSchemeConfigurationModel.lambda$0$1$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$0(EventsSchemeConfigurationModel this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EventsSchemePathSettings eventsSchemePathSettings = this$0.currentSettings;
        if (eventsSchemePathSettings != null) {
            eventsSchemePathSettings.setUseCustomPath(it.isSelected());
        }
        this$0.updatePathField();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$1(EventsSchemeConfigurationModel this$0, TextFieldWithBrowseButton it) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JCheckBox jCheckBox = this$0.useCustomPathCheckBox;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomPathCheckBox");
                jCheckBox = null;
            }
            if (!jCheckBox.isSelected()) break block2;
            EventsSchemePathSettings eventsSchemePathSettings = this$0.currentSettings;
            if (eventsSchemePathSettings != null) {
                eventsSchemePathSettings.setCustomPath(this$0.pathField.getText());
            }
        }
        return Unit.INSTANCE;
    }

    private static final EventsSchemePathSettings updatePanel$lambda$0(String $recorderId, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new EventsSchemePathSettings($recorderId);
    }

    private static final EventsSchemePathSettings updatePanel$lambda$1(Function1 $tmp0, Object p0) {
        return (EventsSchemePathSettings)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0005R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/EventsSchemeConfigurationModel$EventsSchemePathSettings;", "", "recorderId", "", "<init>", "(Ljava/lang/String;)V", "defaultPath", "customPath", "getCustomPath", "()Ljava/lang/String;", "setCustomPath", "useCustomPath", "", "getUseCustomPath", "()Z", "setUseCustomPath", "(Z)V", "currentPath", "getCurrentPath", "intellij.platform.statistics.devkit"})
    public static final class EventsSchemePathSettings {
        @NotNull
        private final String defaultPath;
        @Nullable
        private String customPath;
        private boolean useCustomPath;

        public EventsSchemePathSettings(@NotNull String recorderId) {
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            this.defaultPath = ((Object)BaseEventLogMetadataPersistence.getDefaultMetadataFile((String)recorderId, (String)"events-scheme.json", null)).toString();
            com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings pathSettings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(recorderId);
            if (pathSettings != null) {
                this.customPath = pathSettings.getCustomPath();
                this.useCustomPath = pathSettings.isUseCustomPath();
            }
        }

        @Nullable
        public final String getCustomPath() {
            return this.customPath;
        }

        public final void setCustomPath(@Nullable String string) {
            this.customPath = string;
        }

        public final boolean getUseCustomPath() {
            return this.useCustomPath;
        }

        public final void setUseCustomPath(boolean bl) {
            this.useCustomPath = bl;
        }

        @NotNull
        public final String getCurrentPath() {
            String customEventsSchemePath = this.customPath;
            return this.useCustomPath && customEventsSchemePath != null ? customEventsSchemePath : this.defaultPath;
        }
    }
}

