/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.bitext;

import java.io.IOException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;

public class DifferentPunctuationRule
extends BitextRule {
    public DifferentPunctuationRule() {
        this.setLocQualityIssueType(ITSIssueType.Typographical);
    }

    @Override
    public String getDescription() {
        return "Check if translation has ending punctuation different from the source";
    }

    @Override
    public String getId() {
        return "DIFFERENT_PUNCTUATION";
    }

    @Override
    public String getMessage() {
        return "Source and target translation have different ending punctuation";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sourceText, AnalyzedSentence targetText) throws IOException {
        AnalyzedTokenReadings[] translationTokens = targetText.getTokens();
        AnalyzedTokenReadings[] sourceTokens = sourceText.getTokens();
        AnalyzedTokenReadings lastTransTokenObj = translationTokens[translationTokens.length - 1];
        String lastTransToken = lastTransTokenObj.getToken();
        if ((".".equals(lastTransToken) || "?".equals(lastTransToken) || "!".equals(lastTransToken)) && !lastTransToken.equals(sourceTokens[sourceTokens.length - 1].getToken())) {
            int endPos = lastTransTokenObj.getEndPos();
            return new RuleMatch[]{new RuleMatch(this, targetText, 1, endPos, this.getMessage())};
        }
        return RuleMatch.EMPTY_ARRAY;
    }
}

