/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import com.google.protobuf.ByteString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.proto.DigestProto;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/zip/signer/metadata/Digest;", "", "algorithm", "Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "digestBytes", "", "protobufRepresentation", "Lorg/jetbrains/zip/signer/proto/DigestProto;", "<init>", "(Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;[BLorg/jetbrains/zip/signer/proto/DigestProto;)V", "(Lorg/jetbrains/zip/signer/proto/DigestProto;)V", "(Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;[B)V", "getAlgorithm", "()Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "getDigestBytes", "()[B", "getProtobufRepresentation", "()Lorg/jetbrains/zip/signer/proto/DigestProto;", "lib"})
public final class Digest {
    @NotNull
    private final ContentDigestAlgorithm algorithm;
    @NotNull
    private final byte[] digestBytes;
    @NotNull
    private final DigestProto protobufRepresentation;

    private Digest(ContentDigestAlgorithm algorithm, byte[] digestBytes, DigestProto protobufRepresentation) {
        this.algorithm = algorithm;
        this.digestBytes = digestBytes;
        this.protobufRepresentation = protobufRepresentation;
    }

    @NotNull
    public final ContentDigestAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getDigestBytes() {
        return this.digestBytes;
    }

    @NotNull
    public final DigestProto getProtobufRepresentation() {
        return this.protobufRepresentation;
    }

    public Digest(@NotNull DigestProto protobufRepresentation) {
        Intrinsics.checkNotNullParameter((Object)protobufRepresentation, (String)"protobufRepresentation");
        DigestProto.AlgorithmId algorithmId = protobufRepresentation.getAlgorithmId();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)algorithmId), (String)"getAlgorithmId(...)");
        ContentDigestAlgorithm contentDigestAlgorithm = ContentDigestAlgorithm.Companion.fromProtobufEnum(algorithmId);
        byte[] byArray = protobufRepresentation.getDigestBytes().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        this(contentDigestAlgorithm, byArray, protobufRepresentation);
    }

    public Digest(@NotNull ContentDigestAlgorithm algorithm, @NotNull byte[] digestBytes) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)digestBytes, (String)"digestBytes");
        DigestProto digestProto = DigestProto.newBuilder().setAlgorithmId(algorithm.toProtobufEnum()).setDigestBytes(ByteString.copyFrom((byte[])digestBytes)).build();
        Intrinsics.checkNotNullExpressionValue((Object)digestProto, (String)"build(...)");
        this(algorithm, digestBytes, digestProto);
    }
}

