/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.data.MapEntry;
import org.assertj.core.error.ElementsShouldBe;
import org.assertj.core.error.ElementsShouldSatisfy;
import org.assertj.core.error.NoElementsShouldSatisfy;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldContainEntries;
import org.assertj.core.error.ShouldContainEntry;
import org.assertj.core.error.ShouldContainExactly;
import org.assertj.core.error.ShouldContainKey;
import org.assertj.core.error.ShouldContainKeys;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainOnlyKeys;
import org.assertj.core.error.ShouldContainValue;
import org.assertj.core.error.ShouldContainValues;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainKey;
import org.assertj.core.error.ShouldNotContainKeys;
import org.assertj.core.error.ShouldNotContainValue;
import org.assertj.core.error.UnsatisfiedRequirement;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.ErrorMessages;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Preconditions;

public class Maps {
    private static final Maps INSTANCE = new Maps();
    Failures failures = Failures.instance();
    Conditions conditions = Conditions.instance();

    public static Maps instance() {
        return INSTANCE;
    }

    Maps() {
    }

    public <K, V> void assertAllSatisfy(AssertionInfo info, Map<K, V> actual, BiConsumer<? super K, ? super V> entryRequirements) {
        java.util.Objects.requireNonNull(entryRequirements, "The BiConsumer<K, V> expressing the assertions requirements must not be null");
        this.assertNotNull(info, actual);
        List<UnsatisfiedRequirement> unsatisfiedRequirements = actual.entrySet().stream().map(entry -> Maps.failsRequirements(entryRequirements, entry)).flatMap(Optional::stream).collect(Collectors.toList());
        if (!unsatisfiedRequirements.isEmpty()) {
            throw this.failures.failure(info, ElementsShouldSatisfy.elementsShouldSatisfy(actual, unsatisfiedRequirements, info));
        }
    }

    private static <K, V> Optional<UnsatisfiedRequirement> failsRequirements(BiConsumer<? super K, ? super V> entryRequirements, Map.Entry<K, V> entry) {
        try {
            entryRequirements.accept(entry.getKey(), entry.getValue());
        }
        catch (AssertionError ex2) {
            return Optional.of(new UnsatisfiedRequirement(entry, ex2));
        }
        return Optional.empty();
    }

    public <K, V> void assertAnySatisfy(AssertionInfo info, Map<K, V> actual, BiConsumer<? super K, ? super V> entryRequirements) {
        java.util.Objects.requireNonNull(entryRequirements, "The BiConsumer<K, V> expressing the assertions requirements must not be null");
        this.assertNotNull(info, actual);
        ArrayList<UnsatisfiedRequirement> unsatisfiedRequirements = new ArrayList<UnsatisfiedRequirement>();
        for (Map.Entry<K, V> entry : actual.entrySet()) {
            Optional<UnsatisfiedRequirement> result2 = Maps.failsRequirements(entryRequirements, entry);
            if (result2.isEmpty()) {
                return;
            }
            unsatisfiedRequirements.add(result2.get());
        }
        throw this.failures.failure(info, ElementsShouldSatisfy.elementsShouldSatisfyAny(actual, unsatisfiedRequirements, info));
    }

    public <K, V> void assertNoneSatisfy(AssertionInfo info, Map<K, V> actual, BiConsumer<? super K, ? super V> entryRequirements) {
        java.util.Objects.requireNonNull(entryRequirements, "The BiConsumer<K, V> expressing the assertions requirements must not be null");
        this.assertNotNull(info, actual);
        List erroneousEntries = actual.entrySet().stream().map(entry -> this.failsRestrictions((Map.Entry)entry, entryRequirements)).flatMap(Optional::stream).collect(Collectors.toList());
        if (!erroneousEntries.isEmpty()) {
            throw this.failures.failure(info, NoElementsShouldSatisfy.noElementsShouldSatisfy(actual, erroneousEntries));
        }
    }

    private <V, K> Optional<Map.Entry<K, V>> failsRestrictions(Map.Entry<K, V> entry, BiConsumer<? super K, ? super V> entryRequirements) {
        try {
            entryRequirements.accept(entry.getKey(), entry.getValue());
        }
        catch (AssertionError e2) {
            return Optional.empty();
        }
        return Optional.of(entry);
    }

    public void assertNullOrEmpty(AssertionInfo info, Map<?, ?> actual) {
        if (actual != null && !actual.isEmpty()) {
            throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
        }
    }

    public void assertEmpty(AssertionInfo info, Map<?, ?> actual) {
        this.assertNotNull(info, actual);
        if (!actual.isEmpty()) {
            throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
        }
    }

    public void assertNotEmpty(AssertionInfo info, Map<?, ?> actual) {
        this.assertNotNull(info, actual);
        if (actual.isEmpty()) {
            throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public void assertHasSize(AssertionInfo info, Map<?, ?> actual, int expectedSize) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizes(actual, actual.size(), expectedSize, info);
    }

    public void assertHasSizeGreaterThan(AssertionInfo info, Map<?, ?> actual, int boundary) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizeGreaterThan(actual, boundary, actual.size(), info);
    }

    public void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info, Map<?, ?> actual, int boundary) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizeGreaterThanOrEqualTo(actual, boundary, actual.size(), info);
    }

    public void assertHasSizeLessThan(AssertionInfo info, Map<?, ?> actual, int boundary) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizeLessThan(actual, boundary, actual.size(), info);
    }

    public void assertHasSizeLessThanOrEqualTo(AssertionInfo info, Map<?, ?> actual, int boundary) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizeLessThanOrEqualTo(actual, boundary, actual.size(), info);
    }

    public void assertHasSizeBetween(AssertionInfo info, Map<?, ?> actual, int lowerBoundary, int higherBoundary) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizeBetween(actual, lowerBoundary, higherBoundary, actual.size(), info);
    }

    public void assertHasSameSizeAs(AssertionInfo info, Map<?, ?> map2, Iterable<?> other) {
        this.assertNotNull(info, map2);
        CommonValidations.hasSameSizeAsCheck(info, map2, other, map2.size());
    }

    public void assertHasSameSizeAs(AssertionInfo info, Map<?, ?> map2, Object other) {
        this.assertNotNull(info, map2);
        Arrays.assertIsArray(info, other);
        CommonValidations.hasSameSizeAsCheck(info, map2, other, map2.size());
    }

    public void assertHasSameSizeAs(AssertionInfo info, Map<?, ?> map2, Map<?, ?> other) {
        this.assertNotNull(info, map2);
        CommonValidations.hasSameSizeAsCheck(info, map2, other, map2.size());
    }

    public <K, V> void assertContains(AssertionInfo info, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        Maps.failIfNull(entries2);
        this.assertNotNull(info, actual);
        if (actual.isEmpty() && entries2.length == 0) {
            return;
        }
        this.failIfEntriesIsEmptySinceActualIsNotEmpty(info, actual, entries2);
        this.failIfAnyEntryNotFoundInActualMap(info, actual, entries2);
    }

    public <K, V> void assertContainsAllEntriesOf(AssertionInfo info, Map<K, V> actual, Map<? extends K, ? extends V> other) {
        Maps.failIfNull(other);
        this.assertNotNull(info, actual);
        if (other.isEmpty()) {
            return;
        }
        this.failIfAnyEntryNotFoundInActualMap(info, actual, other.entrySet().toArray(new Map.Entry[0]));
    }

    public <K, V> void assertContainsAnyOf(AssertionInfo info, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        Maps.failIfNull(entries2);
        this.assertNotNull(info, actual);
        if (actual.isEmpty() && entries2.length == 0) {
            return;
        }
        this.failIfEntriesIsEmptySinceActualIsNotEmpty(info, actual, entries2);
        for (Map.Entry<? extends K, ? extends V> entry : entries2) {
            if (!Maps.containsEntry(actual, entry)) continue;
            return;
        }
        throw this.failures.failure(info, ShouldContainAnyOf.shouldContainAnyOf(actual, entries2));
    }

    public <K, V> void assertHasEntrySatisfying(AssertionInfo info, Map<K, V> actual, K key, Condition<? super V> valueCondition) {
        this.assertContainsKey(info, actual, key);
        this.conditions.assertIsNotNull(valueCondition);
        V value = actual.get(key);
        if (!valueCondition.matches(value)) {
            throw this.failures.failure(info, ElementsShouldBe.elementsShouldBe(actual, value, valueCondition));
        }
    }

    public <K, V> void assertHasEntrySatisfying(AssertionInfo info, Map<K, V> actual, K key, Consumer<? super V> valueRequirements) {
        this.assertContainsKey(info, actual, key);
        java.util.Objects.requireNonNull(valueRequirements, "The Consumer<V> expressing the assertions requirements must not be null");
        V value = actual.get(key);
        valueRequirements.accept(value);
    }

    public <K, V> void assertHasEntrySatisfying(AssertionInfo info, Map<K, V> actual, Condition<? super Map.Entry<K, V>> entryCondition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(entryCondition);
        for (Map.Entry<K, V> entry : actual.entrySet()) {
            if (!entryCondition.matches(entry)) continue;
            return;
        }
        throw this.failures.failure(info, ShouldContainEntry.shouldContainEntry(actual, entryCondition));
    }

    public <K, V> void assertHasEntrySatisfyingConditions(AssertionInfo info, Map<K, V> actual, Condition<? super K> keyCondition, Condition<? super V> valueCondition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(keyCondition, "The condition to evaluate for entries key should not be null", new Object[0]);
        this.conditions.assertIsNotNull(valueCondition, "The condition to evaluate for entries value should not be null", new Object[0]);
        for (Map.Entry<K, V> entry : actual.entrySet()) {
            if (!keyCondition.matches(entry.getKey()) || !valueCondition.matches(entry.getValue())) continue;
            return;
        }
        throw this.failures.failure(info, ShouldContainEntry.shouldContainEntry(actual, keyCondition, valueCondition));
    }

    public <K> void assertHasKeySatisfying(AssertionInfo info, Map<K, ?> actual, Condition<? super K> keyCondition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(keyCondition);
        for (K key : actual.keySet()) {
            if (!keyCondition.matches(key)) continue;
            return;
        }
        throw this.failures.failure(info, ShouldContainKey.shouldContainKey(actual, keyCondition));
    }

    public <V> void assertHasValueSatisfying(AssertionInfo info, Map<?, V> actual, Condition<? super V> valueCondition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(valueCondition);
        for (V value : actual.values()) {
            if (!valueCondition.matches(value)) continue;
            return;
        }
        throw this.failures.failure(info, ShouldContainValue.shouldContainValue(actual, valueCondition));
    }

    public <K, V> void assertDoesNotContain(AssertionInfo info, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        Maps.failIfNullOrEmpty(entries2);
        this.assertNotNull(info, actual);
        LinkedHashSet<Map.Entry<? extends K, ? extends V>> found = new LinkedHashSet<Map.Entry<? extends K, ? extends V>>();
        for (Map.Entry<? extends K, ? extends V> entry : entries2) {
            if (!Maps.containsEntry(actual, entry)) continue;
            found.add(entry);
        }
        if (!found.isEmpty()) {
            throw this.failures.failure(info, ShouldNotContain.shouldNotContain(actual, entries2, found));
        }
    }

    public <K, V> void assertContainsKeys(AssertionInfo info, Map<K, V> actual, K[] keys) {
        this.assertNotNull(info, actual);
        java.util.Objects.requireNonNull(keys, ErrorMessages.keysToLookForIsNull("array of keys"));
        if (actual.isEmpty() && keys.length == 0) {
            return;
        }
        Maps.failIfEmpty(keys, ErrorMessages.keysToLookForIsEmpty("array of keys"));
        Set<K> notFound = Maps.getNotFoundKeys(actual, keys);
        if (!notFound.isEmpty()) {
            throw this.failures.failure(info, ShouldContainKeys.shouldContainKeys(actual, notFound));
        }
    }

    public <K, V> void assertContainsKey(AssertionInfo info, Map<K, V> actual, K key) {
        this.assertContainsKeys(info, actual, org.assertj.core.util.Arrays.array(key));
    }

    public <K, V> void assertDoesNotContainKey(AssertionInfo info, Map<K, V> actual, K key) {
        this.assertNotNull(info, actual);
        if (Maps.containsKey(actual, key)) {
            throw this.failures.failure(info, ShouldNotContainKey.shouldNotContainKey(actual, key));
        }
    }

    public <K, V> void assertDoesNotContainKeys(AssertionInfo info, Map<K, V> actual, K[] keys) {
        this.assertNotNull(info, actual);
        java.util.Objects.requireNonNull(keys, ErrorMessages.keysToLookForIsNull("array of keys"));
        Set<K> found = Maps.getFoundKeys(actual, keys);
        if (!found.isEmpty()) {
            throw this.failures.failure(info, ShouldNotContainKeys.shouldNotContainKeys(actual, found));
        }
    }

    public <K, V> void assertContainsOnlyKeys(AssertionInfo info, Map<K, V> actual, K[] keys) {
        this.assertContainsOnlyKeys(info, actual, "array of keys", keys);
    }

    public <K, V> void assertContainsOnlyKeys(AssertionInfo info, Map<K, V> actual, Iterable<? extends K> keys) {
        this.assertContainsOnlyKeys(info, actual, "keys iterable", IterableUtil.toArray(keys));
    }

    private <K, V> void assertContainsOnlyKeys(AssertionInfo info, Map<K, V> actual, String placeholderForErrorMessages, K[] keys) {
        this.assertNotNull(info, actual);
        java.util.Objects.requireNonNull(keys, ErrorMessages.keysToLookForIsNull(placeholderForErrorMessages));
        if (actual.isEmpty() && keys.length == 0) {
            return;
        }
        Maps.failIfEmpty(keys, ErrorMessages.keysToLookForIsEmpty(placeholderForErrorMessages));
        Set<K> notFound = Maps.getNotFoundKeys(actual, keys);
        Set<K> notExpected = Maps.getNotExpectedKeys(actual, keys);
        if (!notFound.isEmpty() || !notExpected.isEmpty()) {
            throw this.failures.failure(info, ShouldContainOnlyKeys.shouldContainOnlyKeys(actual, keys, notFound, notExpected));
        }
    }

    private static <K> Set<K> getFoundKeys(Map<K, ?> actual, K[] expectedKeys) {
        LinkedHashSet<K> found = new LinkedHashSet<K>();
        for (K expectedKey : expectedKeys) {
            if (!Maps.containsKey(actual, expectedKey)) continue;
            found.add(expectedKey);
        }
        return found;
    }

    private static <K> Set<K> getNotFoundKeys(Map<K, ?> actual, K[] expectedKeys) {
        LinkedHashSet<K> notFound = new LinkedHashSet<K>();
        for (K expectedKey : expectedKeys) {
            if (Maps.containsKey(actual, expectedKey)) continue;
            notFound.add(expectedKey);
        }
        return notFound;
    }

    private static <K> boolean containsKey(Map<K, ?> actual, K key) {
        try {
            return actual.containsKey(key);
        }
        catch (NullPointerException e2) {
            if (key == null) {
                return false;
            }
            throw e2;
        }
    }

    private static <K> Set<K> getNotExpectedKeys(Map<K, ?> actual, K[] expectedKeys) {
        try {
            Map<K, ?> clonedMap = Maps.clone(actual);
            for (K expectedKey : expectedKeys) {
                clonedMap.remove(expectedKey);
            }
            return clonedMap.keySet();
        }
        catch (NoSuchMethodException | RuntimeException e2) {
            LinkedHashMap copiedMap = new LinkedHashMap(actual);
            for (K expectedKey : expectedKeys) {
                copiedMap.remove(expectedKey);
            }
            return copiedMap.keySet();
        }
    }

    private static <K, V> Map<K, V> clone(Map<K, V> map2) throws NoSuchMethodException {
        if (Maps.isMultiValueMapAdapterInstance(map2)) {
            throw new IllegalArgumentException("Cannot clone MultiValueMapAdapter");
        }
        try {
            if (map2 instanceof Cloneable) {
                return (Map)map2.getClass().getMethod("clone", new Class[0]).invoke(map2, new Object[0]);
            }
            try {
                return (Map)map2.getClass().getConstructor(map2.getClass()).newInstance(map2);
            }
            catch (NoSuchMethodException e2) {
                Map newMap = (Map)map2.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                newMap.putAll(map2);
                return newMap;
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e3) {
            throw new IllegalStateException(e3);
        }
    }

    private static boolean isMultiValueMapAdapterInstance(Map<?, ?> map2) {
        return Maps.isInstanceOf(map2, "org.springframework.util.MultiValueMapAdapter");
    }

    private static boolean isInstanceOf(Object object, String className) {
        try {
            Class<?> type = Class.forName(className);
            return type.isInstance(object);
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public <K, V> void assertContainsValue(AssertionInfo info, Map<K, V> actual, V value) {
        this.assertNotNull(info, actual);
        if (!Maps.containsValue(actual, value)) {
            throw this.failures.failure(info, ShouldContainValue.shouldContainValue(actual, value));
        }
    }

    public <K, V> void assertContainsValues(AssertionInfo info, Map<K, V> actual, V[] values) {
        this.assertNotNull(info, actual);
        java.util.Objects.requireNonNull(values, "The array of values to look for should not be null");
        if (actual.isEmpty() && values.length == 0) {
            return;
        }
        Maps.failIfEmpty(values, ErrorMessages.valuesToLookForIsEmpty());
        Set<V> notFound = Maps.getNotFoundValues(actual, values);
        if (!notFound.isEmpty()) {
            throw this.failures.failure(info, ShouldContainValues.shouldContainValues(actual, notFound));
        }
    }

    public <K, V> void assertDoesNotContainValue(AssertionInfo info, Map<K, V> actual, V value) {
        this.assertNotNull(info, actual);
        if (Maps.containsValue(actual, value)) {
            throw this.failures.failure(info, ShouldNotContainValue.shouldNotContainValue(actual, value));
        }
    }

    private static <V> Set<V> getNotFoundValues(Map<?, V> actual, V[] expectedValues) {
        LinkedHashSet<V> notFound = new LinkedHashSet<V>();
        for (V expectedValue : expectedValues) {
            if (Maps.containsValue(actual, expectedValue)) continue;
            notFound.add(expectedValue);
        }
        return notFound;
    }

    private static <V> boolean containsValue(Map<?, V> actual, V value) {
        try {
            return actual.containsValue(value);
        }
        catch (NullPointerException e2) {
            if (value == null) {
                return false;
            }
            throw e2;
        }
    }

    public <K, V> void assertContainsOnly(AssertionInfo info, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        this.doCommonContainsCheck(info, actual, entries2);
        if (actual.isEmpty() && entries2.length == 0) {
            return;
        }
        this.failIfEntriesIsEmptySinceActualIsNotEmpty(info, actual, entries2);
        Set<Map.Entry<K, V>> notFound = Maps.getNotFoundEntries(actual, entries2);
        Set<Map.Entry<K, V>> notExpected = Maps.getNotExpectedEntries(actual, entries2);
        if (!notFound.isEmpty() || !notExpected.isEmpty()) {
            throw this.failures.failure(info, ShouldContainOnly.shouldContainOnly(actual, entries2, notFound, notExpected));
        }
    }

    private static <K, V> Set<Map.Entry<? extends K, ? extends V>> getNotFoundEntries(Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        LinkedHashSet<Map.Entry<K, V>> notFound = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry<? extends K, ? extends V> entry : entries2) {
            if (Maps.containsEntry(actual, entry)) continue;
            notFound.add(entry);
        }
        return notFound;
    }

    private static <K, V> Set<Map.Entry<K, V>> getNotExpectedEntries(Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        LinkedHashSet<Map.Entry<K, V>> notExpected = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : Maps.mapWithoutExpectedEntries(actual, entries2).entrySet()) {
            MapEntry<K, V> mapEntry = MapEntry.entry(entry.getKey(), entry.getValue());
            notExpected.add(mapEntry);
        }
        return notExpected;
    }

    private static <K, V> Map<K, V> mapWithoutExpectedEntries(Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] expectedEntries) {
        try {
            Map<K, V> clonedMap = Maps.clone(actual);
            Maps.removeEntries(clonedMap, expectedEntries);
            return clonedMap;
        }
        catch (NoSuchMethodException | RuntimeException e2) {
            LinkedHashMap<K, V> copiedMap = new LinkedHashMap<K, V>(actual);
            Maps.removeEntries(copiedMap, expectedEntries);
            return copiedMap;
        }
    }

    private static <K, V> void removeEntries(Map<K, V> map2, Map.Entry<? extends K, ? extends V>[] entries2) {
        for (Map.Entry<K, V> entry : entries2) {
            if (!Maps.containsEntry(map2, entry)) continue;
            map2.remove(entry.getKey());
        }
    }

    public <K, V> void assertContainsExactly(AssertionInfo info, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        this.doCommonContainsCheck(info, actual, entries2);
        if (actual.isEmpty() && entries2.length == 0) {
            return;
        }
        this.failIfEntriesIsEmptySinceActualIsNotEmpty(info, actual, entries2);
        this.assertHasSameSizeAs(info, actual, entries2);
        LinkedHashSet<Map.Entry<K, V>> notFound = new LinkedHashSet<Map.Entry<K, V>>();
        LinkedHashSet<Map.Entry<K, V>> notExpected = new LinkedHashSet<Map.Entry<K, V>>();
        this.compareActualMapAndExpectedEntries(actual, entries2, notExpected, notFound);
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            int index = 0;
            for (K keyFromActual : actual.keySet()) {
                if (!java.util.Objects.deepEquals(keyFromActual, entries2[index].getKey())) {
                    MapEntry<K, V> actualEntry = MapEntry.entry(keyFromActual, actual.get(keyFromActual));
                    throw this.failures.failure(info, ShouldContainExactly.elementsDifferAtIndex(actualEntry, entries2[index], index));
                }
                ++index;
            }
            return;
        }
        throw this.failures.failure(info, ShouldContainExactly.shouldContainExactly(actual, org.assertj.core.util.Arrays.asList(entries2), notFound, notExpected));
    }

    private <K, V> void compareActualMapAndExpectedEntries(Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2, Set<Map.Entry<? extends K, ? extends V>> notExpected, Set<Map.Entry<? extends K, ? extends V>> notFound) {
        Map<K, V> expectedEntries = Maps.entriesToMap(entries2);
        LinkedHashMap<K, V> actualEntries = new LinkedHashMap<K, V>(actual);
        for (Map.Entry<Object, Object> entry : expectedEntries.entrySet()) {
            if (Maps.containsEntry(actualEntries, MapEntry.entry(entry.getKey(), entry.getValue()))) {
                actualEntries.remove(entry.getKey());
                continue;
            }
            notFound.add(MapEntry.entry(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : actualEntries.entrySet()) {
            notExpected.add(MapEntry.entry(entry.getKey(), entry.getValue()));
        }
    }

    private <K, V> void doCommonContainsCheck(AssertionInfo info, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        this.assertNotNull(info, actual);
        Maps.failIfNull(entries2);
    }

    private <K, V> void failIfAnyEntryNotFoundInActualMap(AssertionInfo info, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        LinkedHashSet entriesWithKeyNotFound = new LinkedHashSet();
        LinkedHashSet entriesWithWrongValue = new LinkedHashSet();
        for (Map.Entry<K, V> entry : entries2) {
            java.util.Objects.requireNonNull(entry, ErrorMessages.entryToLookForIsNull());
            if (!actual.containsKey(entry.getKey())) {
                entriesWithKeyNotFound.add(entry);
                continue;
            }
            if (Maps.containsEntry(actual, entry)) continue;
            entriesWithWrongValue.add(entry);
        }
        if (!entriesWithWrongValue.isEmpty() || !entriesWithKeyNotFound.isEmpty()) {
            throw this.failures.failure(info, ShouldContainEntries.shouldContainEntries(actual, entries2, entriesWithWrongValue, entriesWithKeyNotFound, info.representation()));
        }
    }

    private static <K, V> Map<K, V> entriesToMap(Map.Entry<? extends K, ? extends V>[] entries2) {
        LinkedHashMap<K, V> expectedEntries = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries2) {
            expectedEntries.put(entry.getKey(), entry.getValue());
        }
        return expectedEntries;
    }

    private static <K> void failIfEmpty(K[] keys, String errorMessage) {
        Preconditions.checkArgument(keys.length > 0, errorMessage, new Object[0]);
    }

    private static <K, V> void failIfEmpty(Map.Entry<? extends K, ? extends V>[] entries2) {
        Preconditions.checkArgument(entries2.length > 0, "The array of entries to look for should not be empty", new Object[0]);
    }

    private static <K, V> void failIfNullOrEmpty(Map.Entry<? extends K, ? extends V>[] entries2) {
        Maps.failIfNull(entries2);
        Maps.failIfEmpty(entries2);
    }

    private static <K, V> void failIfNull(Map.Entry<? extends K, ? extends V>[] entries2) {
        java.util.Objects.requireNonNull(entries2, ErrorMessages.entriesToLookForIsNull());
    }

    private static <K, V> void failIfNull(Map<? extends K, ? extends V> map2) {
        java.util.Objects.requireNonNull(map2, ErrorMessages.mapOfEntriesToLookForIsNull());
    }

    private static <K, V> boolean containsEntry(Map<K, V> actual, Map.Entry<? extends K, ? extends V> entry) {
        java.util.Objects.requireNonNull(entry, ErrorMessages.entryToLookForIsNull());
        return actual.containsKey(entry.getKey()) && java.util.Objects.deepEquals(actual.get(entry.getKey()), entry.getValue());
    }

    private void assertNotNull(AssertionInfo info, Map<?, ?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private <K, V> void failIfEntriesIsEmptySinceActualIsNotEmpty(AssertionInfo info, Map<K, V> actual, Map.Entry<? extends K, ? extends V>[] entries2) {
        if (entries2.length == 0) {
            throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
        }
    }
}

