/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.consistent;

import com.dynatrace.hash4j.consistent.ConsistentBucketSetHasher;
import com.dynatrace.hash4j.consistent.ConsistentJumpBackBucketHasher;
import com.dynatrace.hash4j.internal.ArraySizeUtil;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.EmptyArray;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import java.util.Arrays;
import java.util.Objects;

class ConsistentJumpBackAnchorBucketSetHasher
implements ConsistentBucketSetHasher {
    private static final String ILLEGAL_STATE_EXCEPTION_MESSAGE = "Illegal state!";
    private static final String NO_BUCKETS_AVAILABLE_EXCEPTION_MESSAGE = "No buckets available!";
    private int historicMaxNumBuckets = 0;
    private int numRemovedBuckets = 0;
    private int[] removedBuckets;
    private long[] ka;
    private final PseudoRandomGenerator pseudoRandomGenerator;

    ConsistentJumpBackAnchorBucketSetHasher(PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        Objects.requireNonNull(pseudoRandomGeneratorProvider);
        this.pseudoRandomGenerator = pseudoRandomGeneratorProvider.create();
        this.removedBuckets = EmptyArray.EMPTY_INT_ARRAY;
        this.ka = EmptyArray.EMPTY_LONG_ARRAY;
    }

    @Override
    public int addBucket() {
        int b;
        if (this.numRemovedBuckets <= 0) {
            b = this.historicMaxNumBuckets++;
            if (this.historicMaxNumBuckets < this.removedBuckets.length) {
                this.removedBuckets[this.historicMaxNumBuckets] = 0;
            }
        } else {
            --this.numRemovedBuckets;
            b = this.removedBuckets[this.numRemovedBuckets];
            this.ka[b] = 0L;
        }
        return b;
    }

    @Override
    public boolean removeBucket(int b) {
        if (b < 0 || b >= this.historicMaxNumBuckets || this.isRemoved(b)) {
            return false;
        }
        if (this.historicMaxNumBuckets - 1 == this.numRemovedBuckets) {
            this.historicMaxNumBuckets = 0;
            this.numRemovedBuckets = 0;
            this.removedBuckets = EmptyArray.EMPTY_INT_ARRAY;
            this.ka = EmptyArray.EMPTY_LONG_ARRAY;
        } else if (b == this.historicMaxNumBuckets - 1 && this.numRemovedBuckets == 0) {
            --this.historicMaxNumBuckets;
        } else {
            if (this.removedBuckets.length <= this.numRemovedBuckets) {
                this.removedBuckets = Arrays.copyOf(this.removedBuckets, Math.min(this.historicMaxNumBuckets - 1, ArraySizeUtil.increaseArraySize(this.removedBuckets.length, this.numRemovedBuckets)));
            }
            this.removedBuckets[this.numRemovedBuckets] = b;
            ++this.numRemovedBuckets;
            int n = this.historicMaxNumBuckets - this.numRemovedBuckets;
            int h = this.bucketAtView(n, n + 1, null);
            if (this.ka.length <= b) {
                this.ka = Arrays.copyOf(this.ka, Math.min(this.historicMaxNumBuckets, ArraySizeUtil.increaseArraySize(this.ka.length, b)));
            }
            this.ka[b] = (long)(h - b) << 32 | 0xFFFFFFFFL & (long)n;
        }
        return true;
    }

    private boolean isRemoved(int b) {
        return b < this.ka.length && this.ka[b] != 0L;
    }

    @Override
    public int getBucket(long hash) {
        return this.getBucket(hash, null);
    }

    int getBucket(long hash, Debug debug) {
        int ab;
        if (this.historicMaxNumBuckets <= this.numRemovedBuckets) {
            throw new IllegalStateException(NO_BUCKETS_AVAILABLE_EXCEPTION_MESSAGE);
        }
        if (this.historicMaxNumBuckets <= 1) {
            return 0;
        }
        this.pseudoRandomGenerator.reset(hash);
        int b = ConsistentJumpBackBucketHasher.getBucket(this.historicMaxNumBuckets, this.pseudoRandomGenerator);
        while (b < this.ka.length && (ab = (int)this.ka[b]) != 0) {
            b = this.bucketAtView(this.pseudoRandomGenerator.uniformInt(ab), ab, debug);
        }
        return b;
    }

    @Override
    public int[] getBuckets() {
        int[] result = new int[this.getNumBuckets()];
        int pos = 0;
        for (int b = 0; b < this.historicMaxNumBuckets; ++b) {
            if (this.isRemoved(b)) continue;
            result[pos] = b;
            ++pos;
        }
        return result;
    }

    @Override
    public int getNumBuckets() {
        return this.historicMaxNumBuckets - this.numRemovedBuckets;
    }

    @Override
    public byte[] getState() {
        int serializationSize = Math.toIntExact(4L + 4L * (long)this.numRemovedBuckets);
        byte[] result = new byte[serializationSize];
        ByteArrayUtil.setInt(result, 0, this.historicMaxNumBuckets);
        int r = 0;
        int pos = 4;
        while (r < this.numRemovedBuckets) {
            int b = this.removedBuckets[r];
            ByteArrayUtil.setInt(result, pos, b);
            ++r;
            pos += 4;
        }
        return result;
    }

    @Override
    public ConsistentBucketSetHasher setState(byte[] state) {
        return this.setState(state, null);
    }

    private int bucketAtView(int b, int v, Debug debug) {
        long kah;
        while (b < this.ka.length && (int)(kah = this.ka[b]) >= v) {
            b += (int)(kah >>> 32);
            if (debug == null) continue;
            ++debug.counter;
        }
        return b;
    }

    ConsistentBucketSetHasher setState(byte[] state, Debug debug) {
        Objects.requireNonNull(state);
        if (state.length < 4 || (state.length & 3) != 0) {
            throw new IllegalArgumentException(ILLEGAL_STATE_EXCEPTION_MESSAGE);
        }
        this.historicMaxNumBuckets = ByteArrayUtil.getInt(state, 0);
        if (this.historicMaxNumBuckets < 0) {
            throw new IllegalArgumentException(ILLEGAL_STATE_EXCEPTION_MESSAGE);
        }
        this.numRemovedBuckets = state.length - 4 >>> 2;
        if (this.removedBuckets.length < this.numRemovedBuckets) {
            this.removedBuckets = new int[this.numRemovedBuckets];
        }
        int maxRemovedBucket = -1;
        int r = 0;
        int pos = 4;
        while (r < this.numRemovedBuckets) {
            int b = ByteArrayUtil.getInt(state, pos);
            if (b < 0 || b >= this.historicMaxNumBuckets) {
                throw new IllegalArgumentException(ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            this.removedBuckets[r] = b;
            if (maxRemovedBucket < b) {
                maxRemovedBucket = b;
            }
            ++r;
            pos += 4;
        }
        if (this.ka.length <= maxRemovedBucket) {
            this.ka = new long[maxRemovedBucket + 1];
        } else {
            Arrays.fill(this.ka, 0L);
        }
        for (r = 0; r < this.numRemovedBuckets; ++r) {
            int b = this.removedBuckets[r];
            if (this.ka[b] != 0L) {
                throw new IllegalArgumentException(ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            int n = this.historicMaxNumBuckets - 1 - r;
            int h = this.bucketAtView(n, n + 1, debug);
            this.ka[b] = (long)(h - b) << 32 | 0xFFFFFFFFL & (long)n;
        }
        return this;
    }

    static class Debug {
        int counter;

        Debug() {
        }
    }
}

