/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.sdk.ui.evolution.tool.conda.sdk;

import com.intellij.python.sdk.ui.evolution.sdk.EvoSdk;
import com.intellij.python.sdk.ui.icons.PythonSdkUIIcons;
import com.jetbrains.python.packaging.CondaExecutablesLocator;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a8\u0006\t"}, d2={"Lcom/intellij/python/sdk/ui/evolution/tool/conda/sdk/CondaEvoSdkManager;", "", "<init>", "()V", "buildEvoSdk", "Lcom/intellij/python/sdk/ui/evolution/sdk/EvoSdk;", "pythonBinaryPath", "Ljava/nio/file/Path;", "Lcom/jetbrains/python/PythonBinary;", "intellij.python.sdk.ui"})
@ApiStatus.Internal
public final class CondaEvoSdkManager {
    @NotNull
    public static final CondaEvoSdkManager INSTANCE = new CondaEvoSdkManager();

    private CondaEvoSdkManager() {
    }

    @Nullable
    public final EvoSdk buildEvoSdk(@NotNull Path pythonBinaryPath) {
        Intrinsics.checkNotNullParameter((Object)pythonBinaryPath, (String)"pythonBinaryPath");
        Path path = CondaExecutablesLocator.findCondaExecutableRelativeToEnv((Path)pythonBinaryPath);
        if (path == null) {
            return null;
        }
        Path condaExecutablePath = path;
        Path condaEnvsPath = condaExecutablePath.resolve("../../envs");
        String name = ((Object)condaEnvsPath.relativize(pythonBinaryPath.resolve(""))).toString();
        Icon icon = PythonSdkUIIcons.Tools.Anaconda;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Anaconda");
        return new EvoSdk(null, icon, name, pythonBinaryPath, null, 17, null);
    }
}

