/*==============================================================================

FICHIER     : [rdtsc.c]

DATE        : 2006/03/0001 21:20:38

CREATEUR    : [Linux!jef]

COMMENTAIRE :

================================================================================
	Timing using time stamp counter
==============================================================================*/
#include <stdio.h>

#define __IN_RDTSC__
#include "rdtsc.h"

#if ENABLE_COUNTERS

#define rdtsc(low,high) \
     __asm__ __volatile__("rdtsc" : "=a" (low), "=d" (high))

/*------------------------------------------------------------------------------
	COUNTERSTART-
Linux!jef 2006/03/01 21:22:50
------------------------------------------------------------------------------*/

void CounterStart( int no )
{
	rdtsc( Counters[no].sLow, Counters[no].sHigh );
}

/*------------------------------------------------------------------------------
	COUNTERSTOP-
Linux!jef 2006/03/01 21:24:01
------------------------------------------------------------------------------*/

void CounterStop( int no )
{
	unsigned int eLow, eHigh;
	unsigned long long before,after;

	rdtsc( eLow, eHigh );
	before =  Counters[no].sLow + (((long long)Counters[no].sHigh)<<32);
	after = eLow + (((long long)eHigh)<<32);

	Counters[no].sumTsc += after - before;
}
/*------------------------------------------------------------------------------
	COUNTERSREPORT-
Linux!jef 2006/03/01 21:27:08
------------------------------------------------------------------------------*/

void CountersReport()
{
	int i;

	for( i = 0; i < MAX_COUNTER; i++ ) {
		if( Counters[i].sumTsc ) {
			fprintf(stderr,"%s ran for %lld cycles\n", Counters[i].name, Counters[i].sumTsc );
		}
	}
}
#endif

