/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNodeGen;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=ThreadModuleBuiltins.class)
public final class ThreadModuleBuiltinsFactory {
    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(AllocateLockNodeFactory.getInstance(), GetCurrentThreadIdNodeFactory.getInstance(), GetNativeIdNodeFactory.getInstance(), GetThreadCountNodeFactory.getInstance(), GetThreadStackSizeNodeFactory.getInstance(), StartNewThreadNodeFactory.getInstance(), SetSentinelNodeFactory.getInstance(), InterruptMainThreadNodeFactory.getInstance(), ExitThreadNodeFactory.getInstance(), DaemonThreadsAllowedNodeFactory.getInstance());
    }

    @GeneratedBy(value=ThreadModuleBuiltins.AllocateLockNode.class)
    public static final class AllocateLockNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.AllocateLockNode> {
        private static final AllocateLockNodeFactory ALLOCATE_LOCK_NODE_FACTORY_INSTANCE = new AllocateLockNodeFactory();

        private AllocateLockNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.AllocateLockNode> getNodeClass() {
            return ThreadModuleBuiltins.AllocateLockNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public ThreadModuleBuiltins.AllocateLockNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AllocateLockNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadModuleBuiltins.AllocateLockNode> getInstance() {
            return ALLOCATE_LOCK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.AllocateLockNode create() {
            return new AllocateLockNodeGen();
        }

        @GeneratedBy(value=ThreadModuleBuiltins.AllocateLockNode.class)
        public static final class AllocateLockNodeGen
        extends ThreadModuleBuiltins.AllocateLockNode {
            private AllocateLockNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                PythonLanguage language__ = PythonLanguage.get(this);
                return this.construct(arg0Value, arg1Value, language__);
            }
        }
    }

    @GeneratedBy(value=ThreadModuleBuiltins.GetCurrentThreadIdNode.class)
    public static final class GetCurrentThreadIdNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.GetCurrentThreadIdNode> {
        private static final GetCurrentThreadIdNodeFactory GET_CURRENT_THREAD_ID_NODE_FACTORY_INSTANCE = new GetCurrentThreadIdNodeFactory();

        private GetCurrentThreadIdNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.GetCurrentThreadIdNode> getNodeClass() {
            return ThreadModuleBuiltins.GetCurrentThreadIdNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public ThreadModuleBuiltins.GetCurrentThreadIdNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return GetCurrentThreadIdNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadModuleBuiltins.GetCurrentThreadIdNode> getInstance() {
            return GET_CURRENT_THREAD_ID_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.GetCurrentThreadIdNode create(ReadArgumentNode[] arguments) {
            return new GetCurrentThreadIdNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadModuleBuiltins.GetCurrentThreadIdNode.class)
        public static final class GetCurrentThreadIdNodeGen
        extends ThreadModuleBuiltins.GetCurrentThreadIdNode {
            private GetCurrentThreadIdNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return ThreadModuleBuiltins.GetCurrentThreadIdNode.getId();
            }
        }
    }

    @GeneratedBy(value=ThreadModuleBuiltins.GetNativeIdNode.class)
    public static final class GetNativeIdNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.GetNativeIdNode> {
        private static final GetNativeIdNodeFactory GET_NATIVE_ID_NODE_FACTORY_INSTANCE = new GetNativeIdNodeFactory();

        private GetNativeIdNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.GetNativeIdNode> getNodeClass() {
            return ThreadModuleBuiltins.GetNativeIdNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public ThreadModuleBuiltins.GetNativeIdNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return GetNativeIdNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadModuleBuiltins.GetNativeIdNode> getInstance() {
            return GET_NATIVE_ID_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.GetNativeIdNode create(ReadArgumentNode[] arguments) {
            return new GetNativeIdNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadModuleBuiltins.GetNativeIdNode.class)
        public static final class GetNativeIdNodeGen
        extends ThreadModuleBuiltins.GetNativeIdNode {
            private GetNativeIdNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return ThreadModuleBuiltins.GetNativeIdNode.getId();
            }
        }
    }

    @GeneratedBy(value=ThreadModuleBuiltins.GetThreadCountNode.class)
    static final class GetThreadCountNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.GetThreadCountNode> {
        private static final GetThreadCountNodeFactory GET_THREAD_COUNT_NODE_FACTORY_INSTANCE = new GetThreadCountNodeFactory();

        private GetThreadCountNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.GetThreadCountNode> getNodeClass() {
            return ThreadModuleBuiltins.GetThreadCountNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public ThreadModuleBuiltins.GetThreadCountNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return GetThreadCountNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<ThreadModuleBuiltins.GetThreadCountNode> getInstance() {
            return GET_THREAD_COUNT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.GetThreadCountNode create() {
            return new GetThreadCountNodeGen();
        }

        @GeneratedBy(value=ThreadModuleBuiltins.GetThreadCountNode.class)
        static final class GetThreadCountNodeGen
        extends ThreadModuleBuiltins.GetThreadCountNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private GetThreadCountNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    return this.getCount(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private long executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.getCount(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadModuleBuiltins.GetThreadStackSizeNode.class)
    static final class GetThreadStackSizeNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.GetThreadStackSizeNode> {
        private static final GetThreadStackSizeNodeFactory GET_THREAD_STACK_SIZE_NODE_FACTORY_INSTANCE = new GetThreadStackSizeNodeFactory();

        private GetThreadStackSizeNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.GetThreadStackSizeNode> getNodeClass() {
            return ThreadModuleBuiltins.GetThreadStackSizeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public ThreadModuleBuiltins.GetThreadStackSizeNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return GetThreadStackSizeNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<ThreadModuleBuiltins.GetThreadStackSizeNode> getInstance() {
            return GET_THREAD_STACK_SIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.GetThreadStackSizeNode create() {
            return new GetThreadStackSizeNodeGen();
        }

        @GeneratedBy(value=ThreadModuleBuiltins.GetThreadStackSizeNode.class)
        static final class GetThreadStackSizeNodeGen
        extends ThreadModuleBuiltins.GetThreadStackSizeNode {
            private static final InlineSupport.StateField STATE_0_GetThreadStackSizeNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyNumberAsSizeNode INLINED_FALLBACK_AS_SIZE_NODE_ = PyNumberAsSizeNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberAsSizeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetThreadStackSizeNode_UPDATER.subUpdater(2, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"fallback_asSizeNode__field1_", Node.class)}));
            private static final PRaiseNode INLINED_FALLBACK_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetThreadStackSizeNode_UPDATER.subUpdater(7, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_asSizeNode__field1_;

            private GetThreadStackSizeNodeGen() {
            }

            private boolean fallbackGuard_(Object arg0Value) {
                PNone arg0Value_;
                return !(arg0Value instanceof PNone) || !PGuards.isNoValue(arg0Value_ = (PNone)arg0Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    PNone arg0Value_;
                    if ((state_0 & 1) != 0 && arg0Value instanceof PNone && PGuards.isNoValue(arg0Value_ = (PNone)arg0Value)) {
                        return this.getStackSize(arg0Value_);
                    }
                    if ((state_0 & 2) != 0) {
                        GetThreadStackSizeNodeGen inliningTarget__ = this;
                        if (this.fallbackGuard_(arg0Value)) {
                            return ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(frameValue, arg0Value, inliningTarget__, INLINED_FALLBACK_AS_SIZE_NODE_, INLINED_FALLBACK_RAISE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                PNone arg0Value_;
                int state_0 = this.state_0_;
                if (arg0Value instanceof PNone && PGuards.isNoValue(arg0Value_ = (PNone)arg0Value)) {
                    this.state_0_ = state_0 |= 1;
                    return this.getStackSize(arg0Value_);
                }
                GetThreadStackSizeNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                this.state_0_ = state_0 |= 2;
                return ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(frameValue, arg0Value, inliningTarget__, INLINED_FALLBACK_AS_SIZE_NODE_, INLINED_FALLBACK_RAISE_NODE_);
            }
        }
    }

    @GeneratedBy(value=ThreadModuleBuiltins.StartNewThreadNode.class)
    static final class StartNewThreadNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.StartNewThreadNode> {
        private static final StartNewThreadNodeFactory START_NEW_THREAD_NODE_FACTORY_INSTANCE = new StartNewThreadNodeFactory();

        private StartNewThreadNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.StartNewThreadNode> getNodeClass() {
            return ThreadModuleBuiltins.StartNewThreadNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public ThreadModuleBuiltins.StartNewThreadNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return StartNewThreadNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<ThreadModuleBuiltins.StartNewThreadNode> getInstance() {
            return START_NEW_THREAD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.StartNewThreadNode create() {
            return new StartNewThreadNodeGen();
        }

        @GeneratedBy(value=ThreadModuleBuiltins.StartNewThreadNode.class)
        static final class StartNewThreadNodeGen
        extends ThreadModuleBuiltins.StartNewThreadNode {
            private static final InlineSupport.StateField STATE_0_StartNewThreadNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final ExpandKeywordStarargsNode INLINED_GET_KW_ARGS_NODE_ = ExpandKeywordStarargsNodeGen.inline(InlineSupport.InlineTarget.create(ExpandKeywordStarargsNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_StartNewThreadNode_UPDATER.subUpdater(1, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getKwArgsNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private CallNode callNode_;
            @Node.Child
            private ExecutePositionalStarargsNode getArgsNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getKwArgsNode__field1_;

            private StartNewThreadNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                ExecutePositionalStarargsNode getArgsNode__;
                CallNode callNode__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (callNode__ = this.callNode_) != null && (getArgsNode__ = this.getArgsNode_) != null) {
                    StartNewThreadNodeGen inliningTarget__ = this;
                    PythonContext context__ = PythonContext.get(this);
                    return ThreadModuleBuiltins.StartNewThreadNode.start(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, context__, callNode__, getArgsNode__, INLINED_GET_KW_ARGS_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                PythonContext context__ = null;
                StartNewThreadNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                context__ = PythonContext.get(this);
                CallNode callNode__ = (CallNode)this.insert(CallNode.create());
                Objects.requireNonNull(callNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.callNode_ = callNode__;
                ExecutePositionalStarargsNode getArgsNode__ = (ExecutePositionalStarargsNode)this.insert(ExecutePositionalStarargsNode.create());
                Objects.requireNonNull(getArgsNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.getArgsNode_ = getArgsNode__;
                this.state_0_ = state_0 |= 1;
                return ThreadModuleBuiltins.StartNewThreadNode.start(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, context__, callNode__, getArgsNode__, INLINED_GET_KW_ARGS_NODE_);
            }
        }
    }

    @GeneratedBy(value=ThreadModuleBuiltins.SetSentinelNode.class)
    static final class SetSentinelNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.SetSentinelNode> {
        private static final SetSentinelNodeFactory SET_SENTINEL_NODE_FACTORY_INSTANCE = new SetSentinelNodeFactory();

        private SetSentinelNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.SetSentinelNode> getNodeClass() {
            return ThreadModuleBuiltins.SetSentinelNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public ThreadModuleBuiltins.SetSentinelNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return SetSentinelNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<ThreadModuleBuiltins.SetSentinelNode> getInstance() {
            return SET_SENTINEL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.SetSentinelNode create(ReadArgumentNode[] arguments) {
            return new SetSentinelNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadModuleBuiltins.SetSentinelNode.class)
        static final class SetSentinelNodeGen
        extends ThreadModuleBuiltins.SetSentinelNode {
            private SetSentinelNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.setSentinel();
            }
        }
    }

    @GeneratedBy(value=ThreadModuleBuiltins.InterruptMainThreadNode.class)
    static final class InterruptMainThreadNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.InterruptMainThreadNode> {
        private static final InterruptMainThreadNodeFactory INTERRUPT_MAIN_THREAD_NODE_FACTORY_INSTANCE = new InterruptMainThreadNodeFactory();

        private InterruptMainThreadNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.InterruptMainThreadNode> getNodeClass() {
            return ThreadModuleBuiltins.InterruptMainThreadNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public ThreadModuleBuiltins.InterruptMainThreadNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return InterruptMainThreadNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<ThreadModuleBuiltins.InterruptMainThreadNode> getInstance() {
            return INTERRUPT_MAIN_THREAD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.InterruptMainThreadNode create() {
            return new InterruptMainThreadNodeGen();
        }

        @GeneratedBy(value=ThreadModuleBuiltins.InterruptMainThreadNode.class)
        static final class InterruptMainThreadNodeGen
        extends ThreadModuleBuiltins.InterruptMainThreadNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private InterruptMainThreadNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return this.getCount(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.getCount(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadModuleBuiltins.ExitThreadNode.class)
    static final class ExitThreadNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.ExitThreadNode> {
        private static final ExitThreadNodeFactory EXIT_THREAD_NODE_FACTORY_INSTANCE = new ExitThreadNodeFactory();

        private ExitThreadNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.ExitThreadNode> getNodeClass() {
            return ThreadModuleBuiltins.ExitThreadNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public ThreadModuleBuiltins.ExitThreadNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return ExitThreadNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<ThreadModuleBuiltins.ExitThreadNode> getInstance() {
            return EXIT_THREAD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.ExitThreadNode create(ReadArgumentNode[] arguments) {
            return new ExitThreadNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadModuleBuiltins.ExitThreadNode.class)
        static final class ExitThreadNodeGen
        extends ThreadModuleBuiltins.ExitThreadNode {
            private ExitThreadNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                ExitThreadNodeGen inliningTarget__ = this;
                return ThreadModuleBuiltins.ExitThreadNode.exit(inliningTarget__);
            }
        }
    }

    @GeneratedBy(value=ThreadModuleBuiltins.DaemonThreadsAllowedNode.class)
    public static final class DaemonThreadsAllowedNodeFactory
    implements NodeFactory<ThreadModuleBuiltins.DaemonThreadsAllowedNode> {
        private static final DaemonThreadsAllowedNodeFactory DAEMON_THREADS_ALLOWED_NODE_FACTORY_INSTANCE = new DaemonThreadsAllowedNodeFactory();

        private DaemonThreadsAllowedNodeFactory() {
        }

        public Class<ThreadModuleBuiltins.DaemonThreadsAllowedNode> getNodeClass() {
            return ThreadModuleBuiltins.DaemonThreadsAllowedNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public ThreadModuleBuiltins.DaemonThreadsAllowedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return DaemonThreadsAllowedNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadModuleBuiltins.DaemonThreadsAllowedNode> getInstance() {
            return DAEMON_THREADS_ALLOWED_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadModuleBuiltins.DaemonThreadsAllowedNode create(ReadArgumentNode[] arguments) {
            return new DaemonThreadsAllowedNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadModuleBuiltins.DaemonThreadsAllowedNode.class)
        public static final class DaemonThreadsAllowedNodeGen
        extends ThreadModuleBuiltins.DaemonThreadsAllowedNode {
            private DaemonThreadsAllowedNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return ThreadModuleBuiltins.DaemonThreadsAllowedNode.daemonAllowed();
            }
        }
    }
}

