/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

public abstract class TpSlotLen {
    private TpSlotLen() {
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class CallSlotLenPythonNode
    extends Node {
        CallSlotLenPythonNode() {
        }

        abstract int execute(VirtualFrame var1, TpSlot.TpSlotPythonSingle var2, Object var3);

        @Specialization
        static int doIt(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Bind Node inliningTarget, @Cached PythonDispatchers.UnaryPythonSlotDispatcherNode dispatcherNode, @Cached InlinedBranchProfile genericCheck, @Cached PRaiseNode raiseNode, @Cached PyNumberIndexNode indexNode, @Cached CastToJavaIntLossyNode castLossy, @Cached PyNumberAsSizeNode asSizeNode) {
            Object result = dispatcherNode.execute(frame, inliningTarget, slot.getCallable(), slot.getType(), self);
            if (!genericCheck.wasEntered(inliningTarget)) {
                try {
                    return CallSlotLenPythonNode.checkLen(inliningTarget, raiseNode, PGuards.expectInteger(result));
                }
                catch (UnexpectedResultException e) {
                    genericCheck.enter(inliningTarget);
                }
            }
            return CallSlotLenPythonNode.convertAndCheckLen(frame, inliningTarget, result, indexNode, castLossy, asSizeNode, raiseNode);
        }

        static int checkLen(Node inliningTarget, PRaiseNode raiseNode, int len) {
            if (len < 0) {
                CallSlotLenPythonNode.raiseLenGt0(inliningTarget, raiseNode);
            }
            return len;
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raiseLenGt0(Node inliningTarget, PRaiseNode raiseNode) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.LEN_SHOULD_RETURN_GT_ZERO);
        }

        public static int convertAndCheckLen(VirtualFrame frame, Node inliningTarget, Object result, PyNumberIndexNode indexNode, CastToJavaIntLossyNode castLossy, PyNumberAsSizeNode asSizeNode, PRaiseNode raiseNode) {
            int len;
            Object index = indexNode.execute((Frame)frame, inliningTarget, result);
            try {
                len = asSizeNode.executeExact((Frame)frame, inliningTarget, index);
            }
            catch (PException e) {
                throw CallSlotLenPythonNode.checkNegative(inliningTarget, castLossy, raiseNode, e, index);
            }
            return CallSlotLenPythonNode.checkLen(inliningTarget, raiseNode, len);
        }

        @HostCompilerDirectives.InliningCutoff
        private static PException checkNegative(Node inliningTarget, CastToJavaIntLossyNode castLossy, PRaiseNode raiseNode, PException e, Object index) {
            int len = castLossy.execute(inliningTarget, index);
            CallSlotLenPythonNode.checkLen(inliningTarget, raiseNode, len);
            throw e;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotLenNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "sq_mp_len");

        public abstract int execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4);

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static int callCachedBuiltin(VirtualFrame frame, TpSlotLenBuiltin<?> slot, Object self, @Cached(value="slot") TpSlotLenBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createSlotNode()") LenBuiltinNode slotNode) {
            return slotNode.executeInt(frame, self);
        }

        @Specialization
        static int callPython(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Cached(inline=false) CallSlotLenPythonNode callSlotNode) {
            return callSlotNode.execute(frame, slot, self);
        }

        @Specialization
        static int callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotCExtNative slot, Object self, @Cached.Exclusive @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached.Exclusive @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached.Exclusive @Cached(inline=false) ExternalFunctionNodes.CheckPrimitiveFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState state = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, state, C_API_TIMING, SpecialMethodNames.T___LEN__, slot.callable, toNativeNode.execute(self));
            long l = checkResultNode.executeLong(state, SpecialMethodNames.T___LEN__, result);
            if (!PInt.isIntRange(l)) {
                CallSlotLenNode.raiseOverflow(inliningTarget, raiseNode, l);
            }
            return (int)l;
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raiseOverflow(Node inliningTarget, PRaiseNode raiseNode, long l) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, l);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        static int callGenericSimpleBuiltin(TpSlotLenBuiltinSimple<?> slot, Object self) {
            return slot.executeUncached(self);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static int callGenericComplexBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotLenBuiltinComplex<?> slot, Object self, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(1);
            PArguments.setArgument(arguments, 0, self);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            return (Integer)invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class LenBuiltinNode
    extends PythonUnaryBuiltinNode {
        public abstract int executeInt(VirtualFrame var1, Object var2);

        @Override
        public final Object execute(VirtualFrame frame, Object obj) {
            return this.executeInt(frame, obj);
        }
    }

    public static abstract class TpSlotLenBuiltinComplex<T extends LenBuiltinNode>
    extends TpSlotLenBuiltin<T> {
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotLenBuiltinComplex(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        @Override
        public final void initialize(PythonLanguage language) {
            RootCallTarget callTarget = TpSlotLenBuiltinComplex.createSlotCallTarget(language, SIGNATURE, this.getNodeFactory(), "__len__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, callTarget);
        }
    }

    public static abstract class TpSlotLenBuiltinSimple<T extends LenBuiltinNode>
    extends TpSlotLenBuiltin<T> {
        protected TpSlotLenBuiltinSimple(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        protected abstract int executeUncached(Object var1);

        @Override
        public final void initialize(PythonLanguage language) {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TpSlotLenBuiltin<T extends LenBuiltinNode>
    extends TpSlot.TpSlotBuiltinBase<T> {
        static final BuiltinSlotWrapperSignature SIGNATURE = BuiltinSlotWrapperSignature.UNARY;

        protected TpSlotLenBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory, SIGNATURE, ExternalFunctionNodes.PExternalFunctionWrapper.LENFUNC);
        }

        final LenBuiltinNode createSlotNode() {
            return (LenBuiltinNode)((Object)this.createNode());
        }
    }
}

