/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.builtins.modules.SSLModuleBuiltins;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.ssl.CertUtils;
import com.oracle.graal.python.builtins.objects.ssl.SSLCipher;
import com.oracle.graal.python.builtins.objects.ssl.SSLMethod;
import com.oracle.graal.python.builtins.objects.ssl.SSLProtocol;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.io.IOException;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public final class PSSLContext
extends PythonBuiltinObject {
    private final SSLMethod method;
    private final SSLContext context;
    private boolean checkHostname;
    private int verifyMode;
    private SSLCipher[] ciphers;
    private long options;
    private SSLProtocol minimumVersion;
    private SSLProtocol maximumVersion;
    private int verifyFlags;
    private String[] alpnProtocols;
    private KeyStore caKeystore;
    private KeyStore chainKeystore;
    private Set<X509CRL> crls;
    private boolean useDefaultTrustStore;
    private char[] password = PythonUtils.EMPTY_CHAR_ARRAY;

    public PSSLContext(Object cls, Shape instanceShape, SSLMethod method, int verifyFlags, boolean checkHostname, int verifyMode, SSLContext context) {
        super(cls, instanceShape);
        assert (method != null);
        this.method = method;
        this.context = context;
        this.verifyFlags = verifyFlags;
        this.checkHostname = checkHostname;
        this.verifyMode = verifyMode;
        this.ciphers = SSLModuleBuiltins.defaultCiphers;
        SSLModuleBuiltins.LOGGER.fine(() -> String.format("PSSLContext() method: %s, verifyMode: %d, verifyFlags: %d, checkHostname: %b", new Object[]{method, verifyMode, verifyFlags, checkHostname}));
    }

    @CompilerDirectives.TruffleBoundary
    private KeyStore getCAKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (this.caKeystore == null) {
            this.caKeystore = KeyStore.getInstance("JKS");
            this.caKeystore.load(null);
        }
        return this.caKeystore;
    }

    @CompilerDirectives.TruffleBoundary
    private KeyStore getChainKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (this.chainKeystore == null) {
            this.chainKeystore = KeyStore.getInstance("JKS");
            this.chainKeystore.load(null);
        }
        return this.chainKeystore;
    }

    @CompilerDirectives.TruffleBoundary
    public X509Certificate[] getCACerts() throws KeyStoreException, NoSuchAlgorithmException {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        if (this.caKeystore != null) {
            Enumeration<String> aliases = this.caKeystore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate cert = (X509Certificate)this.caKeystore.getCertificate(aliases.nextElement());
                result.add(cert);
            }
        }
        if (this.useDefaultTrustStore) {
            X509ExtendedTrustManager tm = this.getDefaultTrustManager();
            for (X509Certificate cert : tm.getAcceptedIssuers()) {
                result.add(cert);
            }
        }
        return result.toArray(new X509Certificate[0]);
    }

    public SSLMethod getMethod() {
        return this.method;
    }

    @CompilerDirectives.TruffleBoundary
    void setCAEntries(Collection<? extends Object> list) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        for (Object object : list) {
            if (object instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)object;
                this.getCAKeyStore().setCertificateEntry(CertUtils.getAlias(cert), cert);
                continue;
            }
            if (object instanceof X509CRL) {
                this.getCRLs().add((X509CRL)object);
                continue;
            }
            throw new IllegalStateException("expected X509Certificate or X509CRL but got " + object.getClass().getName());
        }
    }

    @CompilerDirectives.TruffleBoundary
    private Set<X509CRL> getCRLs() {
        if (this.crls == null) {
            this.crls = new HashSet<X509CRL>();
        }
        return this.crls;
    }

    void setCertChain(PrivateKey pk, char[] password, X509Certificate[] certs) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.password = password;
        this.getChainKeyStore().setKeyEntry(CertUtils.getAlias(pk), pk, password, certs);
    }

    void init() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, InvalidAlgorithmParameterException, IOException, CertificateException {
        X509ExtendedTrustManager defaultTrustManager = this.getDefaultTrustManager();
        X509ExtendedTrustManager trustManager = PSSLContext.getX509ExtendedTrustManager(this.getTrustManagerFactory(this.getCAKeyStore()).getTrustManagers());
        DelegateTrustManager tm = new DelegateTrustManager(trustManager, defaultTrustManager, this.verifyMode);
        KeyManager[] kms = null;
        if (this.chainKeystore != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(this.chainKeystore, this.password);
            kms = kmf.getKeyManagers();
        }
        this.context.init(kms, new TrustManager[]{tm}, null);
    }

    private X509ExtendedTrustManager getDefaultTrustManager() throws KeyStoreException, NoSuchAlgorithmException {
        if (this.useDefaultTrustStore) {
            TrustManagerFactory tmf = PSSLContext.getTrustManagerFactory();
            tmf.init((KeyStore)null);
            return PSSLContext.getX509ExtendedTrustManager(tmf.getTrustManagers());
        }
        return null;
    }

    private static X509ExtendedTrustManager getX509ExtendedTrustManager(TrustManager[] tms) {
        for (TrustManager tm : tms) {
            if (!(tm instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)tm;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("at least one X509ExtendedTrustManager should be provided.");
    }

    @CompilerDirectives.TruffleBoundary
    private static TrustManagerFactory getTrustManagerFactory() throws NoSuchAlgorithmException {
        return TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
    }

    @CompilerDirectives.TruffleBoundary
    private TrustManagerFactory getTrustManagerFactory(KeyStore ks) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = PSSLContext.getTrustManagerFactory();
        boolean crlCheck = (this.verifyFlags & 4) != 0;
        boolean crlCheckAll = (this.verifyFlags & 8) != 0;
        SSLModuleBuiltins.LOGGER.fine(() -> String.format("PSSLContext.getTrustManagerFactory() crlCheck: %b, crlCheckAll: %b", crlCheck, crlCheckAll));
        if (crlCheck || crlCheckAll) {
            PKIXRevocationChecker rc = (PKIXRevocationChecker)CertPathBuilder.getInstance("PKIX").getRevocationChecker();
            EnumSet<PKIXRevocationChecker.Option> opt = EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS, PKIXRevocationChecker.Option.NO_FALLBACK);
            if (crlCheck) {
                opt.add(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
            }
            rc.setOptions(opt);
            PKIXBuilderParameters params = new PKIXBuilderParameters(ks, (CertSelector)new X509CertSelector());
            params.addCertPathChecker(rc);
            if (this.crls != null && !this.crls.isEmpty()) {
                CertStore certStores = CertStore.getInstance("Collection", new CollectionCertStoreParameters(this.crls));
                params.addCertStore(certStores);
                SSLModuleBuiltins.LOGGER.fine("PSSLContext.getTrustManagerFactory() adding crls");
            }
            tmf.init(new CertPathTrustManagerParameters(params));
        } else {
            tmf.init(ks);
        }
        return tmf;
    }

    public SSLContext getContext() {
        return this.context;
    }

    public boolean getCheckHostname() {
        return this.checkHostname;
    }

    public void setCheckHostname(boolean checkHostname) {
        SSLModuleBuiltins.LOGGER.fine(() -> String.format("PSSLContext.setCheckHostname: %b", checkHostname));
        this.checkHostname = checkHostname;
    }

    int getVerifyMode() {
        return this.verifyMode;
    }

    void setVerifyMode(int verifyMode) {
        assert (verifyMode == 0 || verifyMode == 1 || verifyMode == 2);
        SSLModuleBuiltins.LOGGER.fine(() -> String.format("PSSLContext.setVerifyMode: %d", verifyMode));
        this.verifyMode = verifyMode;
    }

    public void setUseDefaultTrustStore(boolean useDefaultTrustStore) {
        this.useDefaultTrustStore = useDefaultTrustStore;
    }

    @CompilerDirectives.TruffleBoundary
    public List<SSLCipher> computeEnabledCiphers(SSLEngine engine) {
        HashSet<String> allowedCiphers = new HashSet<String>(Arrays.asList(engine.getSupportedCipherSuites()));
        ArrayList<SSLCipher> enabledCiphers = new ArrayList<SSLCipher>(this.ciphers.length);
        for (SSLCipher cipher : this.ciphers) {
            if (!allowedCiphers.contains(cipher.name())) continue;
            enabledCiphers.add(cipher);
        }
        return enabledCiphers;
    }

    public void setCiphers(SSLCipher[] ciphers) {
        if (SSLModuleBuiltins.LOGGER.isLoggable(Level.FINE)) {
            SSLModuleBuiltins.LOGGER.fine("PSSLContext.setCiphers:");
            for (SSLCipher c : ciphers) {
                SSLModuleBuiltins.LOGGER.fine(() -> String.format("\t", new Object[]{c}));
            }
        }
        this.ciphers = ciphers;
    }

    public long getOptions() {
        return this.options;
    }

    public void setOptions(long options) {
        SSLModuleBuiltins.LOGGER.fine(() -> String.format("PSSLContext.setOptions: %d", options));
        this.options = options;
    }

    int getVerifyFlags() {
        return this.verifyFlags;
    }

    void setVerifyFlags(int flags) {
        SSLModuleBuiltins.LOGGER.fine(() -> String.format("PSSLContext.setVerifyFlags: %d", flags));
        this.verifyFlags = flags;
    }

    public String[] getAlpnProtocols() {
        return this.alpnProtocols;
    }

    public void setAlpnProtocols(String[] alpnProtocols) {
        if (SSLModuleBuiltins.LOGGER.isLoggable(Level.FINE)) {
            SSLModuleBuiltins.LOGGER.fine("PSSLContext.setAlpnProtocols:");
            for (String p : alpnProtocols) {
                SSLModuleBuiltins.LOGGER.fine(() -> String.format("\t", p));
            }
        }
        this.alpnProtocols = alpnProtocols;
    }

    public SSLProtocol getMinimumVersion() {
        return this.minimumVersion;
    }

    public void setMinimumVersion(SSLProtocol minimumVersion) {
        SSLModuleBuiltins.LOGGER.fine(() -> String.format("PSSLContext.setMinimumVersion: %s", new Object[]{minimumVersion}));
        this.minimumVersion = minimumVersion;
    }

    public SSLProtocol getMaximumVersion() {
        return this.maximumVersion;
    }

    public void setMaximumVersion(SSLProtocol maximumVersion) {
        SSLModuleBuiltins.LOGGER.fine(() -> String.format("PSSLContext.setMaximumVersion: %s", new Object[]{maximumVersion}));
        this.maximumVersion = maximumVersion;
    }

    public boolean allowsProtocol(SSLProtocol protocol) {
        boolean disabledByOption = (this.options & (long)protocol.getDisableOption()) == 0L;
        boolean inMinBound = this.minimumVersion == null || protocol.getId() >= this.minimumVersion.getId();
        boolean inMaxBound = this.maximumVersion == null || protocol.getId() <= this.maximumVersion.getId();
        return inMinBound && inMaxBound && disabledByOption && this.method.allowsProtocol(protocol);
    }

    @CompilerDirectives.TruffleBoundary
    public String[] computeEnabledProtocols() {
        List<SSLProtocol> supportedProtocols = SSLModuleBuiltins.getSupportedProtocols();
        ArrayList<String> list = new ArrayList<String>(supportedProtocols.size());
        for (SSLProtocol protocol : supportedProtocols) {
            if (!this.allowsProtocol(protocol)) continue;
            String name = protocol.getName();
            list.add(name);
        }
        return list.toArray(new String[0]);
    }

    private static class DelegateTrustManager
    extends X509ExtendedTrustManager {
        private final X509ExtendedTrustManager delegate;
        private final X509ExtendedTrustManager defaultTM;
        private final int verifyMode;
        private X509Certificate[] issuers;

        public DelegateTrustManager(X509ExtendedTrustManager delegate, X509ExtendedTrustManager defaultTM, int verifyMode) {
            this.delegate = delegate;
            this.defaultTM = defaultTM;
            this.verifyMode = verifyMode;
            SSLModuleBuiltins.LOGGER.fine(() -> String.format("PSSLContext.init() using DelegateTrustManager, verifyMode=", verifyMode == 1 ? "SSL_CERT_OPTIONAL" : "SSL_CERT_REQUIRED"));
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            block5: {
                if (this.skipCheckClientTrusted(chain)) {
                    return;
                }
                if (this.canCheckDelegateTrustManager()) {
                    try {
                        this.delegate.checkClientTrusted(chain, authType);
                        return;
                    }
                    catch (CertificateException e) {
                        if (this.defaultTM == null) break block5;
                        throw e;
                    }
                }
            }
            if (this.canCheckDefaultTrustManager()) {
                this.defaultTM.checkClientTrusted(chain, authType);
                return;
            }
            throw new CertificateException("certificate verify failed: unable to get local issuer certificate");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String string, Socket socket) throws CertificateException {
            block5: {
                if (this.skipCheckClientTrusted(chain)) {
                    return;
                }
                if (this.canCheckDelegateTrustManager()) {
                    try {
                        this.delegate.checkClientTrusted(chain, string, socket);
                        return;
                    }
                    catch (CertificateException e) {
                        if (this.defaultTM != null) break block5;
                        throw e;
                    }
                }
            }
            if (this.canCheckDefaultTrustManager()) {
                this.defaultTM.checkClientTrusted(chain, string, socket);
                return;
            }
            throw new CertificateException("certificate verify failed: unable to get local issuer certificate");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String string, SSLEngine ssle) throws CertificateException {
            block5: {
                if (this.skipCheckClientTrusted(chain)) {
                    return;
                }
                if (this.canCheckDelegateTrustManager()) {
                    try {
                        this.delegate.checkClientTrusted(chain, string, ssle);
                        return;
                    }
                    catch (CertificateException e) {
                        if (this.defaultTM != null) break block5;
                        throw e;
                    }
                }
            }
            if (this.canCheckDefaultTrustManager()) {
                this.defaultTM.checkClientTrusted(chain, string, ssle);
                return;
            }
            throw new CertificateException("certificate verify failed: unable to get local issuer certificate");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            block5: {
                if (this.skipCheckServerTrusted()) {
                    return;
                }
                if (this.canCheckDelegateTrustManager()) {
                    try {
                        this.delegate.checkServerTrusted(chain, authType);
                        return;
                    }
                    catch (CertificateException e) {
                        if (this.defaultTM != null) break block5;
                        throw e;
                    }
                }
            }
            if (this.canCheckDefaultTrustManager()) {
                this.defaultTM.checkServerTrusted(chain, authType);
                return;
            }
            throw new CertificateException("certificate verify failed: unable to get local issuer certificate");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String string, Socket socket) throws CertificateException {
            block5: {
                if (this.skipCheckServerTrusted()) {
                    return;
                }
                if (this.canCheckDelegateTrustManager()) {
                    try {
                        this.delegate.checkServerTrusted(chain, string, socket);
                        return;
                    }
                    catch (CertificateException e) {
                        if (this.defaultTM != null) break block5;
                        throw e;
                    }
                }
            }
            if (this.canCheckDefaultTrustManager()) {
                this.defaultTM.checkServerTrusted(chain, string, socket);
                return;
            }
            throw new CertificateException("certificate verify failed: unable to get local issuer certificate");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String string, SSLEngine ssle) throws CertificateException {
            block5: {
                if (this.skipCheckServerTrusted()) {
                    return;
                }
                if (this.canCheckDelegateTrustManager()) {
                    try {
                        this.delegate.checkServerTrusted(chain, string, ssle);
                        return;
                    }
                    catch (CertificateException e) {
                        if (this.defaultTM != null) break block5;
                        throw e;
                    }
                }
            }
            if (this.canCheckDefaultTrustManager()) {
                this.defaultTM.checkServerTrusted(chain, string, ssle);
                return;
            }
            throw new CertificateException("certificate verify failed: unable to get local issuer certificate");
        }

        private boolean skipCheckClientTrusted(X509Certificate[] chain) {
            return this.verifyMode == 0 || this.verifyMode == 1 && (chain == null || chain.length == 0);
        }

        private boolean skipCheckServerTrusted() {
            return this.verifyMode == 0;
        }

        private boolean canCheckDelegateTrustManager() {
            return this.delegate.getAcceptedIssuers().length > 0;
        }

        private boolean canCheckDefaultTrustManager() {
            return this.defaultTM != null && this.defaultTM.getAcceptedIssuers().length > 0;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            if (this.issuers == null) {
                if (this.defaultTM == null) {
                    this.issuers = this.delegate.getAcceptedIssuers();
                } else {
                    X509Certificate[] delegateIssuers = this.delegate.getAcceptedIssuers();
                    X509Certificate[] defaultIssuers = this.defaultTM.getAcceptedIssuers();
                    this.issuers = new X509Certificate[delegateIssuers.length + defaultIssuers.length];
                    PythonUtils.arraycopy(delegateIssuers, 0, this.issuers, 0, delegateIssuers.length);
                    PythonUtils.arraycopy(defaultIssuers, 0, this.issuers, delegateIssuers.length, defaultIssuers.length);
                }
            }
            return this.issuers;
        }
    }
}

