/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.Identifiers;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class DataTypeLookup {
    private static final Logger LOGGER = Logger.getLogger(DataTypeLookup.class.getName());
    private final MutableCatalog catalog;
    private final RetrieverConnection retrieverConnection;
    private final Map<String, ParsedDataTypeName> parsedDataTypeNames;

    DataTypeLookup(RetrieverConnection retrieverConnection, MutableCatalog catalog) {
        this.retrieverConnection = Objects.requireNonNull(retrieverConnection, "No retriever connection provided");
        this.catalog = catalog;
        this.parsedDataTypeNames = new ConcurrentHashMap<String, ParsedDataTypeName>();
    }

    MutableColumnDataType lookupDataType(Schema schema, String databaseSpecificTypeName, int dataType) {
        Optional<MutableColumnDataType> lookupSystemColumnDataType;
        Optional<MutableColumnDataType> lookupColumnDataType;
        ParsedDataTypeName parsedDataTypeName = this.parseDataTypeName(databaseSpecificTypeName);
        Schema lookupSchema = parsedDataTypeName.schema();
        String lookupTypeName = parsedDataTypeName.dataTypeName();
        MutableColumnDataType columnDataType = null;
        if (lookupSchema != null && (lookupColumnDataType = this.catalog.lookupColumnDataType(lookupSchema, lookupTypeName)).isPresent()) {
            columnDataType = lookupColumnDataType.get();
        }
        if (columnDataType == null && (lookupSystemColumnDataType = this.catalog.lookupSystemColumnDataType(lookupTypeName)).isPresent()) {
            columnDataType = lookupSystemColumnDataType.get();
        }
        if (columnDataType == null && (lookupColumnDataType = this.catalog.lookupColumnDataType(schema, lookupTypeName)).isPresent()) {
            columnDataType = lookupColumnDataType.get();
        }
        if (columnDataType == null) {
            columnDataType = new MutableColumnDataType(schema, lookupTypeName, DataTypeType.user_defined);
            LOGGER.log(Level.FINE, new StringFormat("Creating data-type from column or parameter <%s>", columnDataType));
            this.setDataTypeFields(columnDataType, dataType, null);
            this.catalog.addColumnDataType(columnDataType);
        }
        return columnDataType;
    }

    MutableColumnDataType lookupOrCreateDataType(Schema schema, String databaseSpecificTypeName, DataTypeType type, int javaSqlTypeInt, String mappedClassName) {
        MutableColumnDataType columnDataType = this.constructColumnDataTypeForCreate(schema, databaseSpecificTypeName, type);
        boolean isNewColumnDataType = this.catalog.lookupColumnDataType(columnDataType.getSchema(), columnDataType.getName()).isEmpty();
        if (isNewColumnDataType) {
            LOGGER.log(Level.FINE, new StringFormat("Creating %s data-type <%s>", new Object[]{type, columnDataType}));
            this.setDataTypeFields(columnDataType, javaSqlTypeInt, mappedClassName);
            this.catalog.addColumnDataType(columnDataType);
        }
        return columnDataType;
    }

    private MutableColumnDataType constructColumnDataTypeForCreate(Schema schema, String databaseSpecificTypeName, DataTypeType type) {
        ParsedDataTypeName parsedDataTypeName = this.parseDataTypeName(databaseSpecificTypeName);
        Schema lookupSchema = parsedDataTypeName.hasSchema() ? parsedDataTypeName.schema() : schema;
        String lookupTypeName = parsedDataTypeName.dataTypeName();
        if (Utility.isBlank(lookupTypeName)) {
            return new MutableColumnDataType(schema, lookupTypeName, type);
        }
        MutableColumnDataType columnDataType = this.catalog.lookupColumnDataType(lookupSchema, lookupTypeName).orElse(new MutableColumnDataType(schema, lookupTypeName, type));
        return columnDataType;
    }

    private ParsedDataTypeName parseDataTypeName(String databaseSpecificTypeName) {
        Schema unspecifiedSchema = null;
        if (databaseSpecificTypeName == null) {
            return new ParsedDataTypeName(unspecifiedSchema, "");
        }
        if (this.parsedDataTypeNames.containsKey(databaseSpecificTypeName)) {
            return this.parsedDataTypeNames.get(databaseSpecificTypeName);
        }
        if (!databaseSpecificTypeName.contains(".")) {
            ParsedDataTypeName parsedDataTypeName = new ParsedDataTypeName(unspecifiedSchema, databaseSpecificTypeName);
            this.parsedDataTypeNames.put(databaseSpecificTypeName, parsedDataTypeName);
            return parsedDataTypeName;
        }
        Identifiers identifiers = this.retrieverConnection.getIdentifiers();
        String[] splitName = CollectionsUtility.splitList(databaseSpecificTypeName, "\\.");
        if (splitName.length == 0) {
            return new ParsedDataTypeName(unspecifiedSchema, databaseSpecificTypeName);
        }
        for (int i = 0; i < splitName.length; ++i) {
            splitName[i] = identifiers.unquoteName(splitName[i]);
        }
        Schema lookupSchema = switch (splitName.length) {
            default -> unspecifiedSchema;
            case 2 -> this.catalog.getSchemas().stream().filter(dbSchema -> dbSchema.getFullName().endsWith(splitName[0])).findFirst().orElse(unspecifiedSchema);
            case 3 -> {
                String schemaName = new SchemaReference(splitName[0], splitName[1]).getFullName();
                yield this.catalog.lookupSchema(schemaName).orElse((SchemaReference)unspecifiedSchema);
            }
        };
        String simpleTypeName = splitName[splitName.length - 1];
        ParsedDataTypeName parsedDataTypeName = new ParsedDataTypeName(lookupSchema, simpleTypeName);
        this.parsedDataTypeNames.put(databaseSpecificTypeName, parsedDataTypeName);
        return parsedDataTypeName;
    }

    private void setDataTypeFields(MutableColumnDataType columnDataType, int javaSqlTypeInt, String mappedClassName) {
        JavaSqlType javaSqlType = this.retrieverConnection.getJavaSqlTypes().valueOf(javaSqlTypeInt);
        columnDataType.setJavaSqlType(javaSqlType);
        if (Utility.isBlank(mappedClassName)) {
            String dataTypeName = columnDataType.getName();
            TypeMap typeMap = this.retrieverConnection.getTypeMap();
            Object mappedClass = typeMap.containsKey(dataTypeName) ? typeMap.get(dataTypeName) : typeMap.get(javaSqlType.getName());
            columnDataType.setTypeMappedClass((Class<?>)mappedClass);
        } else {
            columnDataType.setTypeMappedClass(mappedClassName);
        }
        columnDataType.withQuoting(this.retrieverConnection.getIdentifiers());
    }

    private record ParsedDataTypeName(Schema schema, String dataTypeName) {
        boolean hasSchema() {
            return this.schema != null;
        }
    }
}

