'''OpenGL extension ARM.shader_core_properties

This module customises the behaviour of the 
OpenGL.raw.GLES2.ARM.shader_core_properties to provide a more 
Python-friendly API

Overview (from the spec)
	
	Applications may wish to know and/or control certain GPU shader core properties
	to select the optimal logic. This extension allows application to query
	and set the number of active GPU shader cores, and query other shader
	core properties for the optimal logic and performance profiling, including:
	
	  * The maximum number of physical shader cores available on the device;
	
	  * The number of active shader cores specified on the device;
	
	  * A bitfield indicating the presence of shader cores on the device;
	
	  * The maximum warp count per shader core available on the device;
	
	  * The maximum number of pixels output per clock per shader core;
	
	  * The maximum number of texels per clock per shader core;
	
	  * The maximum number of single-precision fused multiply-add operations per
	    clock per shader core;

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARM/shader_core_properties.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.ARM.shader_core_properties import *
from OpenGL.raw.GLES2.ARM.shader_core_properties import _EXTENSION_NAME

def glInitShaderCorePropertiesARM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION