/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.autorefresh;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.jkiss.dbeaver.ui.UIUtils;

public class RefreshSettings {
    private static IDialogSettings viewerSettings;
    private final String settingsId;
    private int refreshInterval = 0;
    private boolean stopOnError = true;

    RefreshSettings(String settingsId) {
        this.settingsId = settingsId;
    }

    RefreshSettings(RefreshSettings src) {
        this.settingsId = src.settingsId;
        this.refreshInterval = src.refreshInterval;
        this.stopOnError = src.stopOnError;
    }

    int getRefreshInterval() {
        return this.refreshInterval;
    }

    void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    boolean isStopOnError() {
        return this.stopOnError;
    }

    void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public void loadSettings() {
        IDialogSettings viewerSettings = RefreshSettings.getViewerSettings(this.settingsId);
        if (viewerSettings.get("interval") != null) {
            this.refreshInterval = viewerSettings.getInt("interval");
        }
        if (viewerSettings.get("stopOnError") != null) {
            this.stopOnError = viewerSettings.getBoolean("stopOnError");
        }
    }

    public void saveSettings() {
        IDialogSettings viewerSettings = RefreshSettings.getViewerSettings(this.settingsId);
        viewerSettings.put("interval", this.refreshInterval);
        viewerSettings.put("stopOnError", this.stopOnError);
    }

    private static IDialogSettings getViewerSettings(String section) {
        if (viewerSettings == null) {
            viewerSettings = UIUtils.getDialogSettings("DBeaver.AutoRefresh");
        }
        return UIUtils.getSettingsSection(viewerSettings, section);
    }
}

