/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.DefaultLease;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.LeaseHolder;
import org.gradle.internal.resources.ProjectLockRegistry;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.TaskExecutionLockRegistry;
import org.gradle.internal.work.DefaultSynchronizer;
import org.gradle.internal.work.NoAvailableWorkerLeaseException;
import org.gradle.internal.work.ProjectParallelExecutionController;
import org.gradle.internal.work.ResourceLockStatistics;
import org.gradle.internal.work.Synchronizer;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.internal.work.WorkerLimits;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkerLeaseService
implements WorkerLeaseService,
ProjectParallelExecutionController,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerLeaseService.class);
    private final WorkerLimits workerLimits;
    private final ResourceLockCoordinationService coordinationService;
    private final WorkerLeaseLockRegistry workerLeaseLockRegistry;
    private final ResourceLockStatistics resourceLockStatistics;
    private final AtomicReference<Registries> registries = new AtomicReference<NoRegistries>(new NoRegistries());

    public DefaultWorkerLeaseService(ResourceLockCoordinationService coordinationService, WorkerLimits workerLimits, ResourceLockStatistics resourceLockStatistics) {
        this.workerLimits = workerLimits;
        this.coordinationService = coordinationService;
        this.workerLeaseLockRegistry = new WorkerLeaseLockRegistry(coordinationService);
        this.resourceLockStatistics = resourceLockStatistics;
        LOGGER.info("Using {} worker leases.", (Object)this.workerLimits.getMaxWorkerCount());
    }

    @Override
    public void startProjectExecution(boolean parallel) {
        Registries current = this.registries.get();
        Registries next = current.startProjectExecution(parallel);
        this.setProjectExecutionState(current, next);
    }

    @Override
    public void finishProjectExecution() {
        Registries current = this.registries.get();
        Registries next = current.finishProjectExecution();
        this.setProjectExecutionState(current, next);
    }

    private void setProjectExecutionState(Registries current, Registries next) {
        if (!this.registries.compareAndSet(current, next)) {
            throw new IllegalStateException("Another thread has changed project execution state");
        }
    }

    @Override
    public int getMaxWorkerCount() {
        return this.workerLimits.getMaxWorkerCount();
    }

    @Override
    public WorkerLeaseRegistry.WorkerLease getCurrentWorkerLease() {
        Collection operations = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (operations.isEmpty()) {
            throw new NoAvailableWorkerLeaseException("No worker lease associated with the current thread");
        }
        if (operations.size() != 1) {
            throw new IllegalStateException("Expected the current thread to hold a single worker lease");
        }
        return (WorkerLeaseRegistry.WorkerLease)operations.get(0);
    }

    @Override
    public DefaultWorkerLease newWorkerLease() {
        return this.workerLeaseLockRegistry.newResourceLock();
    }

    @Override
    public boolean isWorkerThread() {
        return this.workerLeaseLockRegistry.holdsLock();
    }

    @Override
    public <T> T runAsWorkerThread(Factory<T> action) {
        Collection locks = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (!locks.isEmpty()) {
            return (T)action.create();
        }
        return this.withLocks(Collections.singletonList(this.newWorkerLease()), action);
    }

    @Override
    public void runAsWorkerThread(Runnable action) {
        this.runAsWorkerThread(Factories.toFactory(action));
    }

    @Override
    public void runAsUnmanagedWorkerThread(Runnable action) {
        Collection locks = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (!locks.isEmpty()) {
            action.run();
        } else {
            this.withLocks(Collections.singletonList(this.workerLeaseLockRegistry.newUnmanagedLease()), action);
        }
    }

    @Override
    public Synchronizer newResource() {
        return new DefaultSynchronizer(this);
    }

    public void stop() {
        this.coordinationService.withStateLock(new Runnable(){

            @Override
            public void run() {
                if (DefaultWorkerLeaseService.this.workerLeaseLockRegistry.hasOpenLocks()) {
                    throw new IllegalStateException("Some worker leases have not been marked as completed.");
                }
            }
        });
        this.resourceLockStatistics.complete();
    }

    @Override
    public boolean getAllowsParallelExecution() {
        return this.registries.get().getProjectLockRegistry().getAllowsParallelExecution();
    }

    @Override
    public ResourceLock getAllProjectsLock(Path buildIdentityPath) {
        return this.registries.get().getProjectLockRegistry().getAllProjectsLock(buildIdentityPath);
    }

    @Override
    public ResourceLock getProjectLock(Path buildIdentityPath, Path projectIdentityPath) {
        return this.registries.get().getProjectLockRegistry().getProjectLock(buildIdentityPath, projectIdentityPath);
    }

    @Override
    public ResourceLock getTaskExecutionLock(Path buildIdentityPath, Path projectIdentityPath) {
        return this.registries.get().getTaskExecutionLockRegistry().getTaskExecutionLock(buildIdentityPath, projectIdentityPath);
    }

    @Override
    public Collection<? extends ResourceLock> getCurrentProjectLocks() {
        return this.registries.get().getProjectLockRegistry().getResourceLocksByCurrentThread();
    }

    @Override
    public void runAsIsolatedTask() {
        Registries registries = this.registries.get();
        this.releaseLocks(registries.getProjectLockRegistry().getResourceLocksByCurrentThread());
        this.releaseLocks(registries.getTaskExecutionLockRegistry().getResourceLocksByCurrentThread());
    }

    @Override
    public void runAsIsolatedTask(Runnable runnable) {
        this.runAsIsolatedTask(Factories.toFactory(runnable));
    }

    @Override
    public <T> T runAsIsolatedTask(Factory<T> factory) {
        Registries registries = this.registries.get();
        Collection projectLocks = registries.getProjectLockRegistry().getResourceLocksByCurrentThread();
        Collection taskLocks = registries.getTaskExecutionLockRegistry().getResourceLocksByCurrentThread();
        ArrayList locks = new ArrayList(projectLocks.size() + taskLocks.size());
        locks.addAll(projectLocks);
        locks.addAll(taskLocks);
        return this.withoutLocks(locks, factory);
    }

    @Override
    public void blocking(Runnable action) {
        Collection projectLocks;
        Registries registries = this.registries.get();
        if (registries.getProjectLockRegistry().mayAttemptToChangeLocks() && !(projectLocks = registries.getProjectLockRegistry().getResourceLocksByCurrentThread()).isEmpty()) {
            ArrayList locks = new ArrayList(projectLocks.size() + 1);
            locks.addAll(projectLocks);
            locks.addAll(this.workerLeaseLockRegistry.getResourceLocksByCurrentThread());
            this.withoutLocks(locks, action);
            return;
        }
        Collection locks = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        this.withoutLocks((Collection<? extends ResourceLock>)locks, action);
    }

    @Override
    public <T> T whileDisallowingProjectLockChanges(Factory<T> action) {
        return this.registries.get().getProjectLockRegistry().whileDisallowingLockChanges(action);
    }

    @Override
    public <T> T allowUncontrolledAccessToAnyProject(Factory<T> factory) {
        return this.registries.get().getProjectLockRegistry().allowUncontrolledAccessToAnyResource(factory);
    }

    @Override
    public boolean isAllowedUncontrolledAccessToAnyProject() {
        return this.registries.get().getProjectLockRegistry().isAllowedUncontrolledAccessToAnyResource();
    }

    @Override
    public void withLocks(Collection<? extends ResourceLock> locks, Runnable runnable) {
        this.withLocks(locks, Factories.toFactory(runnable));
    }

    @Override
    public <T> T withLocks(Collection<? extends ResourceLock> locks, Factory<T> factory) {
        Collection<? extends ResourceLock> locksToAcquire = this.locksNotHeld(locks);
        if (locksToAcquire.isEmpty()) {
            return (T)factory.create();
        }
        return this.withLocksAcquired(locksToAcquire, factory);
    }

    private <T> T withLocksAcquired(Collection<? extends ResourceLock> locksToAcquire, Factory<T> factory) {
        this.acquireLocksWithoutWorkerLeaseWhileBlocked(locksToAcquire);
        return this.resourceLockStatistics.measure("Acquired", locksToAcquire, () -> {
            try {
                Object object = factory.create();
                return object;
            }
            finally {
                this.releaseLocks(locksToAcquire);
            }
        });
    }

    private void releaseLocks(Iterable<? extends ResourceLock> locks) {
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(locks));
    }

    private void acquireLocks(Iterable<? extends ResourceLock> locks) {
        if (DefaultWorkerLeaseService.containsNonWorkerLease(locks)) {
            this.resourceLockStatistics.measureLockAcquisition(locks, () -> this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(locks)));
        } else {
            this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(locks));
        }
    }

    private static boolean containsNonWorkerLease(Iterable<? extends ResourceLock> locks) {
        for (ResourceLock resourceLock : locks) {
            if (resourceLock instanceof WorkerLeaseRegistry.WorkerLease) continue;
            return true;
        }
        return false;
    }

    private Collection<? extends ResourceLock> locksNotHeld(Collection<? extends ResourceLock> locks) {
        if (locks.isEmpty()) {
            return locks;
        }
        final ArrayList locksNotHeld = Lists.newArrayList(locks);
        this.coordinationService.withStateLock(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = locksNotHeld.iterator();
                while (iterator.hasNext()) {
                    ResourceLock lock = (ResourceLock)iterator.next();
                    if (!lock.isLockedByCurrentThread()) continue;
                    iterator.remove();
                }
            }
        });
        return locksNotHeld;
    }

    @Override
    public void withoutLocks(Collection<? extends ResourceLock> locks, Runnable runnable) {
        this.withoutLocks(locks, Factories.toFactory(runnable));
    }

    @Override
    public void withoutLock(ResourceLock lock, Runnable runnable) {
        this.withoutLocks(Collections.singletonList(lock), runnable);
    }

    @Override
    public <T> T withoutLocks(Collection<? extends ResourceLock> locks, Factory<T> factory) {
        if (locks.isEmpty()) {
            return (T)factory.create();
        }
        this.assertAllLocked(locks);
        this.releaseLocks(locks);
        return this.resourceLockStatistics.measure("Released", locks, () -> {
            try {
                Object object = factory.create();
                return object;
            }
            finally {
                this.acquireLocksWithoutWorkerLeaseWhileBlocked(locks);
            }
        });
    }

    private void assertAllLocked(Collection<? extends ResourceLock> locks) {
        if (!this.allLockedByCurrentThread(locks)) {
            throw new IllegalStateException("Not all of the locks specified are currently held by the current thread.  This could lead to orphaned locks.");
        }
    }

    @Override
    public <T> T withReplacedLocks(Collection<? extends ResourceLock> currentLocks, ResourceLock newLock, Factory<T> factory) {
        if (currentLocks.contains(newLock)) {
            return (T)factory.create();
        }
        return this.withoutLocks(currentLocks, () -> this.withLocksAcquired(Collections.singletonList(newLock), factory));
    }

    @Override
    public WorkerLeaseRegistry.WorkerLeaseCompletion startWorker() {
        if (!this.workerLeaseLockRegistry.getResourceLocksByCurrentThread().isEmpty()) {
            throw new IllegalStateException("Current thread is already a worker thread");
        }
        DefaultWorkerLease lease = this.newWorkerLease();
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(lease));
        return lease;
    }

    @Override
    public WorkerLeaseRegistry.WorkerLeaseCompletion maybeStartWorker() {
        Collection operations = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (operations.isEmpty()) {
            return this.startWorker();
        }
        return (WorkerLeaseRegistry.WorkerLeaseCompletion)operations.get(0);
    }

    private void acquireLocksWithoutWorkerLeaseWhileBlocked(Collection<? extends ResourceLock> locks) {
        if (!this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.tryLock(locks))) {
            this.releaseWorkerLeaseAndWaitFor(locks);
        }
    }

    private void releaseWorkerLeaseAndWaitFor(Collection<? extends ResourceLock> locks) {
        Collection workerLeases = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        ArrayList<? extends ResourceLock> allLocks = new ArrayList<ResourceLock>(locks.size() + workerLeases.size());
        allLocks.addAll(workerLeases);
        allLocks.addAll(locks);
        this.withoutLocks((Collection<? extends ResourceLock>)workerLeases, () -> this.acquireLocks(allLocks));
    }

    private boolean allLockedByCurrentThread(final Iterable<? extends ResourceLock> locks) {
        return this.coordinationService.withStateLock(new Supplier<Boolean>(){

            public Boolean get() {
                return CollectionUtils.every((Iterable)locks, (Spec)new Spec<ResourceLock>(){

                    public boolean isSatisfiedBy(ResourceLock lock) {
                        return lock.isLockedByCurrentThread();
                    }
                });
            }
        });
    }

    private class WorkerLeaseLockRegistry
    extends AbstractResourceLockRegistry<String, DefaultWorkerLease> {
        private final LeaseHolder root;

        WorkerLeaseLockRegistry(ResourceLockCoordinationService coordinationService) {
            super(coordinationService);
            this.root = new LeaseHolder(DefaultWorkerLeaseService.this.getMaxWorkerCount());
        }

        DefaultWorkerLease newResourceLock() {
            return new DefaultWorkerLease("worker lease", DefaultWorkerLeaseService.this.coordinationService, this, this.root);
        }

        DefaultWorkerLease newUnmanagedLease() {
            return new DefaultWorkerLease("unmanaged lease", DefaultWorkerLeaseService.this.coordinationService, this, new LeaseHolder(1));
        }
    }

    private class NoRegistries
    extends Registries {
        private NoRegistries() {
        }

        @Override
        public Registries startProjectExecution(boolean parallel) {
            ProjectLockRegistry projectLockRegistry = new ProjectLockRegistry(DefaultWorkerLeaseService.this.coordinationService, parallel);
            TaskExecutionLockRegistry taskLockRegistry = new TaskExecutionLockRegistry(DefaultWorkerLeaseService.this.coordinationService, projectLockRegistry);
            return new ConfiguredRegistries(taskLockRegistry, projectLockRegistry, this);
        }

        @Override
        ProjectLockRegistry getProjectLockRegistry() {
            throw new IllegalStateException("Project execution not started.");
        }

        @Override
        TaskExecutionLockRegistry getTaskExecutionLockRegistry() {
            throw new IllegalStateException("Project execution not started.");
        }

        @Override
        public Registries finishProjectExecution() {
            throw new IllegalStateException("Project execution not started.");
        }
    }

    private static abstract class Registries {
        private Registries() {
        }

        abstract ProjectLockRegistry getProjectLockRegistry();

        abstract TaskExecutionLockRegistry getTaskExecutionLockRegistry();

        abstract Registries startProjectExecution(boolean var1);

        abstract Registries finishProjectExecution();
    }

    private class DefaultWorkerLease
    extends DefaultLease
    implements WorkerLeaseRegistry.WorkerLeaseCompletion,
    WorkerLeaseRegistry.WorkerLease {
        public DefaultWorkerLease(String displayName, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner, LeaseHolder parent) {
            super(displayName, coordinationService, owner, parent);
        }

        @Override
        public void leaseFinish() {
            DefaultWorkerLeaseService.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(this));
        }
    }

    private class ConfiguredRegistries
    extends Registries {
        private final TaskExecutionLockRegistry taskLockRegistry;
        private final ProjectLockRegistry projectLockRegistry;
        private final Registries finishState;

        public ConfiguredRegistries(TaskExecutionLockRegistry taskLockRegistry, ProjectLockRegistry projectLockRegistry, Registries finishState) {
            this.taskLockRegistry = taskLockRegistry;
            this.projectLockRegistry = projectLockRegistry;
            this.finishState = finishState;
        }

        @Override
        ProjectLockRegistry getProjectLockRegistry() {
            return this.projectLockRegistry;
        }

        @Override
        TaskExecutionLockRegistry getTaskExecutionLockRegistry() {
            return this.taskLockRegistry;
        }

        @Override
        public Registries startProjectExecution(boolean parallel) {
            throw new IllegalStateException("Project execution already started.");
        }

        @Override
        public Registries finishProjectExecution() {
            DefaultWorkerLeaseService.this.coordinationService.withStateLock(new Runnable(){

                @Override
                public void run() {
                    if (ConfiguredRegistries.this.projectLockRegistry.hasOpenLocks()) {
                        throw new IllegalStateException("Some project locks have not been unlocked.");
                    }
                    if (ConfiguredRegistries.this.taskLockRegistry.hasOpenLocks()) {
                        throw new IllegalStateException("Some task execution locks have not been unlocked.");
                    }
                }
            });
            return this.finishState;
        }
    }
}

